

#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H

#include <kdialogbase.h>

#include <tqmap.h>


class Config;
class ConfigGeneralPage;
class ConfigPluginsPage;
class ConfigEnvironmentPage;
class ConfigBackendsPage;

/**
 * @short Config dialog
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConfigDialog : public KDialogBase
{
    Q_OBJECT
  
public:
    enum Page {
        GeneralPage,
        PluginsPage,
        EnvironmentPage,
        BackendsPage
    };

    /**
     * Constructor
     */
    ConfigDialog( Config*, TQWidget *parent = 0, const char *name = 0, Page startPage = GeneralPage );

    /**
     * Destructor
     */
    virtual ~ConfigDialog();

private:
    TQFrame* addPage( const TQString &itemName, const TQString &iconName );

    TQFrame* generalPage;
    ConfigGeneralPage* configGeneralPage;
    TQFrame* pluginsPage;
    ConfigPluginsPage* configPluginsPage;
    TQFrame* environmentPage;
    ConfigEnvironmentPage* configEnvironmentPage;
    TQFrame* backendsPage;
    ConfigBackendsPage* configBackendsPage;

    void setConfigChanged( const bool );

    Config* config;

    TQMap<TQString, TQString> binaries;

private slots:
    void configChanged();
    void okClickedSlot();
    void applyClickedSlot();
    void defaultClickedSlot();

signals:
    void saveGeneral();
    void savePlugins();
    void saveEnvironment();
    void saveBackends();

    void resetGeneral();
    void resetPlugins();
    void resetEnvironment();
    void resetBackends();
};

#endif // CONFIGDIALOG_H
