/***************************************************************************
 *   Copyright (C) 2004,5 Max Howell <max.howell@methylblue.com>           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VIS_SOCKETSERVER_H
#define VIS_SOCKETSERVER_H

#include <tqstring.h>          //stack allocated
#include <tqlistview.h>        //baseclass
#include <tqserversocket.h>    //baseclass
#include <tqsocketnotifier.h>  //baseclass

class TQPoint;
class TDEProcess;


namespace Amarok
{
    class SocketServer : public TQServerSocket
    {
    public:
        SocketServer( const TQString &socketName, TQObject *parent );
       ~SocketServer();

    protected:
        int      m_sockfd;
        TQCString m_path;
    };
}


namespace Vis
{
    class SocketServer : public Amarok::SocketServer
    {
    public:
        SocketServer( TQObject* );

        void newConnection( int );

        TQCString path() const { return m_path; }
    };

    class SocketNotifier : public TQSocketNotifier
    {
        Q_OBJECT
  

    public:
        SocketNotifier( int sockfd );

    private slots:
        void request( int );
    };

    class Selector : public TQListView
    {
        Q_OBJECT
  
        Selector( TQWidget *parent=0 );
        SocketServer *m_server;

        virtual void viewportPaintEvent( TQPaintEvent* );

    public:
        static Selector* instance();
        class Item;
        friend class Item;

        ///assigns pid/sockfd combo
        void mapPID( int, int );

        class Item : public TQCheckListItem
        {
        public:
            Item( TQListView *parent, const char *command, const TQString &text, const TQString &s2 )
                    : TQCheckListItem( parent, text, TQCheckListItem::CheckBox )
                    , m_proc( 0 )
                    , m_sockfd( -1 )
                    , m_command( command ) { setText( 1, s2 ); }
           ~Item();

            virtual void stateChange( bool state );

            TDEProcess   *m_proc;
            int         m_sockfd;
            const char *m_command;
        };

    private slots:
        void rightButton( TQListViewItem*, const TQPoint&, int );

    public slots:
        void processExited( TDEProcess* );
        void receivedStdout( TDEProcess*, char*, int );
    };
} //namespace VIS

#endif
