#ifndef _OPTW_SERVERS_H_
#define _OPTW_SERVERS_H_

//=============================================================================
//
//   File : optw_servers.h
//   Creation date : Wed Jun 12 2000 03:29:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_optionswidget.h"
#include "kvi_tal_listview.h"
#include <tqdialog.h>
#include <tqbuttongroup.h>
#include <tqtabwidget.h>

class KviIrcServer;
class KviIrcNetwork;
class KviIrcNetworkData;
class KviMexServerImport;



class KviServerOptionsListViewItem : public KviTalListViewItem
{
public:
	KviServerOptionsListViewItem(KviTalListView *parent,const TQPixmap &pm,const KviIrcNetwork *n);
	KviServerOptionsListViewItem(KviTalListViewItem *parent,const TQPixmap &pm,const KviIrcServer *s);
	~KviServerOptionsListViewItem();
public:
	KviIrcServer * m_pServerData;
	KviIrcNetwork * m_pNetworkData;
public:
	void updateVisibleStrings();
};

class TQLabel;
class TQLineEdit;
class KviIpEditor;
class KviIrcServer;
class TQCheckBox;
class KviTalPopupMenu;
class KviScriptEditor;
class TQComboBox;
class TQPushButton;
class TQToolButton;
class KviNickServRule;
class KviNickServRuleEditor;


class KviNetworkDetailsWidget : public TQDialog
{
	Q_OBJECT
  
public:
	KviNetworkDetailsWidget(TQWidget * par,KviIrcNetwork * d);
	~KviNetworkDetailsWidget();
protected:
	KviScriptEditor       * m_pOnConnectEditor;
	KviScriptEditor       * m_pOnLoginEditor;

	TQLineEdit             * m_pUserEditor;
	TQLineEdit             * m_pPassEditor;
	TQLineEdit             * m_pNickEditor;
	TQLineEdit             * m_pRealEditor;
	TQLineEdit             * m_pDescEditor;

	TQComboBox             * m_pEncodingEditor;
	
	TQCheckBox             * m_pAutoConnectCheck;
	
	KviTalListView             * m_pNickServListView;
	TQCheckBox             * m_pNickServCheck;
	TQPushButton           * m_pAddRuleButton;
	TQPushButton           * m_pDelRuleButton;
	TQPushButton           * m_pEditRuleButton;

	TQStringList             m_lstChannels;
	KviCahnnelListSelector * m_pChannelListSelector;
public:
	void fillData(KviIrcNetwork * d);
protected slots:
	void enableDisableNickServControls();
	void addNickServRule();
	void delNickServRule();
	void editNickServRule();
};

class KviServerDetailsWidget : public TQDialog
{
	Q_OBJECT
  
public:
	KviServerDetailsWidget(TQWidget * par,KviIrcServer * s);
	~KviServerDetailsWidget();
protected:
	TQString                 m_szHostname;
	TQLabel                * m_pHeaderLabel;
	KviScriptEditor       * m_pOnConnectEditor;
	KviScriptEditor       * m_pOnLoginEditor;
	TQLineEdit             * m_pUserEditor;
	TQLineEdit             * m_pPassEditor;
	TQLineEdit             * m_pNickEditor;
	TQLineEdit             * m_pRealEditor;
	TQLineEdit             * m_pDescEditor;
	TQLineEdit             * m_pIdEditor;
	TQComboBox             * m_pLinkFilterEditor;
	TQComboBox             * m_pEncodingEditor;
	KviIpEditor           * m_pIpEditor;
	TQCheckBox             * m_pCacheIpCheck;
	TQCheckBox             * m_pUseSSLCheck;
	TQCheckBox             * m_pUseDefaultInitUMode;
	TQCheckBox             * m_pIMode;
	TQCheckBox             * m_pWMode;
	TQCheckBox             * m_pSMode;
	TQCheckBox             * m_pUseAutoConnect;
	TQCheckBox             * m_pUseIPV6Check;
	TQLineEdit             * m_pPortEditor;
	TQStringList             m_lstChannels;
	KviCahnnelListSelector * m_pChannelListSelector;
	
	TQComboBox             * m_pProxyEditor;
protected slots:
	void useDefaultInitUModeToggled(bool);
	void portEditorTextChanged(const TQString &);
	void useIPV6CheckToggled(bool);
public:
	void setHeaderLabelText();
	void fillData(KviIrcServer *s);
};


#define KVI_OPTIONS_WIDGET_ICON_KviServerOptionsWidget KVI_SMALLICON_SERVER
#define KVI_OPTIONS_WIDGET_NAME_KviServerOptionsWidget __tr2qs_no_lookup("Servers")
#define KVI_OPTIONS_WIDGET_KEYWORDS_KviServerOptionsWidget __tr2qs_no_lookup("connection")
//#define KVI_OPTIONS_WIDGET_NOPARENT_KviServerOptionsWidget KviConnectionOptionsWidget
#define KVI_OPTIONS_WIDGET_PRIORITY_KviServerOptionsWidget 99000

class KviServerOptionsWidget : public KviOptionsWidget
{
	Q_OBJECT
  
public:
	KviServerOptionsWidget(TQWidget * parent);
	~KviServerOptionsWidget();
protected:
	KviTalListView                    * m_pListView;
	TQLabel                       * m_pSrvNetLabel;
	TQLineEdit                    * m_pSrvNetEdit;
	//TQLabel                       * m_pPortLabel;
	//TQLineEdit                    * m_pPortEdit;
	TQPushButton                  * m_pDetailsButton;
	KviTalPopupMenu                   * m_pRecentPopup;
	KviTalPopupMenu                   * m_pContextPopup;
	KviTalPopupMenu                   * m_pImportPopup;
	KviIrcServer                 * m_pClipboard;
	//TQCheckBox                    * m_pIpV6Check;
	TQPushButton                  * m_pConnectCurrent;
	TQPushButton                  * m_pConnectNew;
	KviServerOptionsListViewItem * m_pLastEditedItem;
	KviServerDetailsWidget       * m_pServerDetailsDialog;
	KviNetworkDetailsWidget      * m_pNetworkDetailsDialog;
	KviMexServerImport           * m_pImportFilter;

	TQToolButton                  * m_pNewServerButton;
	TQToolButton                  * m_pNewNetworkButton;
	TQToolButton                  * m_pRemoveButton;
	TQToolButton                  * m_pCopyServerButton;
	TQToolButton                  * m_pPasteServerButton;
	TQToolButton                  * m_pImportButton;
private:
	void fillServerList();
	void saveLastItem();
	KviServerOptionsListViewItem * findNetItem(const char * netname);
protected slots:
	void importerDead();
	void importServer(const KviIrcServer & s,const char * network);
	void importPopupAboutToShow();
	void listViewItemSelectionChanged(KviTalListViewItem *it);
	void listViewRightButtonPressed(KviTalListViewItem *it,const TQPoint &pnt,int col);
	void newNetwork();
	void removeCurrent();
	void newServer();
	void copyServer();
	void pasteServer();
	void clearList();
	void detailsClicked();
	void connectCurrentClicked();
	void recentServersPopupAboutToShow();
	void recentServersPopupClicked(int id);
	void importPopupActivated(int id);
public:
	virtual void commit();
};

#endif //!_OPTW_SERVERS_H_
