/***************************************************************************
                          sq_navigatordropmenu.cpp  -  description
                             -------------------
    begin                : ??? Feb 23 2005
    copyright            : (C) 2005 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tdelocale.h>
#include <tdeaction.h>
#include <tdeio/job.h>
#include <kstringhandler.h>

#include "ksquirrel.h"
#include "sq_popupmenu.h"
#include "sq_navigatordropmenu.h"

SQ_NavigatorDropMenu * SQ_NavigatorDropMenu::m_instance= 0;

SQ_NavigatorDropMenu::SQ_NavigatorDropMenu(TQObject *parent) : TQObject(parent)
{
    m_instance = this;

    TDEActionCollection *ac = new TDEActionCollection(0, this, "Actions for drop menu");

    dropmenu = new SQ_PopupMenu(0);

    // "copy" action
    TDEAction *pACopy = new TDEAction(i18n("Copy here"), "edit-paste", 0, this, TQT_SLOT(slotCopy()), ac, "sq_copy");

    // "move" action
    TDEAction *pAMove = new TDEAction(i18n("Move here"), 0, 0, this, TQT_SLOT(slotMove()), ac, "sq_move");

    // "link" action
    TDEAction *pALink = new TDEAction(i18n("Link here"), "www", 0, this, TQT_SLOT(slotLink()), ac, "sq_link");

    // "cancel" action, this action will do nothing - just close popup menu
    TDEAction *pACancel = new TDEAction(i18n("Cancel"), 0, 0, 0, 0, ac, "sq_cancel");

    // plug all actions to popup menu
    dropmenu->insertTitle(TQString());
    pACopy->plug(dropmenu);
    pAMove->plug(dropmenu);
    pALink->plug(dropmenu);
    dropmenu->insertSeparator();
    pACancel->plug(dropmenu);
}

SQ_NavigatorDropMenu::~SQ_NavigatorDropMenu()
{
    delete dropmenu;
}

void SQ_NavigatorDropMenu::slotCopy()
{
    if(also) emit done(url, SQ_NavigatorDropMenu::Copy);

    TDEIO::Job *job = TDEIO::copy(list, url);
    connect(job, TQT_SIGNAL(result(TDEIO::Job *)), this, TQT_SLOT(slotJobResult(TDEIO::Job *)));
}

void SQ_NavigatorDropMenu::slotMove()
{
    if(also) emit done(url, SQ_NavigatorDropMenu::Move);

    TDEIO::Job *job = TDEIO::move(list, url);
    connect(job, TQT_SIGNAL(result(TDEIO::Job *)), this, TQT_SLOT(slotJobResult(TDEIO::Job *)));
}

void SQ_NavigatorDropMenu::slotLink()
{
    if(also) emit done(url, SQ_NavigatorDropMenu::Link);

    TDEIO::Job *job = TDEIO::link(list, url);
    connect(job, TQT_SIGNAL(result(TDEIO::Job *)), this, TQT_SLOT(slotJobResult(TDEIO::Job *)));
}

void SQ_NavigatorDropMenu::slotJobResult(TDEIO::Job *job)
{
    if(job && job->error())
        job->showErrorDialog(KSquirrel::app());
}

/*
 *  Save destination url and urls of dropped files.
 */
void SQ_NavigatorDropMenu::setupFiles(const KURL::List &l, const KURL &u)
{
    list = l;
    url = u;

    dropmenu->changeTitle(KStringHandler::lsqueeze(u.isLocalFile() ? u.path() : u.prettyURL(), 20));
}

/*
 *  Show popup menu with available actions.
 */
void SQ_NavigatorDropMenu::exec(const TQPoint &pos, bool _also)
{
    also = _also;
    dropmenu->exec(pos);
}

#include "sq_navigatordropmenu.moc"
