/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2003-10-22
 * Description : Raw converter single dialog
 *
 * Copyright (C) 2003-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef SINGLEDIALOG_H
#define SINGLEDIALOG_H

// TQt includes.

#include <tqstring.h>

// KDE includes.

#include <kdialogbase.h>

// Local includes

#include "kpaboutdata.h"

class TQCloseEvent;
class TQCustomEvent;
class TQTimer;

namespace KDcrawIface
{
class DcrawSettingsWidget;
}

namespace KIPIRawConverterPlugin
{

class PreviewWidget;
class ActionThread;
class SaveSettingsWidget;

class SingleDialog : public KDialogBase
{
    Q_OBJECT
  

public:

    SingleDialog(const TQString& file, TQWidget *parent);
    ~SingleDialog();

protected:

    void customEvent(TQCustomEvent *event);
    void closeEvent(TQCloseEvent *e);
    
private:

    void readSettings();
    void saveSettings();

    void busy(bool busy);

    void identified(const TQString&, const TQString& identity, const TQPixmap& preview);

    void previewing(const TQString&);
    void previewed(const TQString&, const TQString& tmpFile);
    void previewFailed(const TQString&);

    void processing(const TQString&);
    void processed(const TQString&, const TQString& tmpFile);
    void processingFailed(const TQString&);

private slots:
    
    void slotDefault();
    void slotClose();
    void slotHelp();
    void slotUser1();
    void slotUser2();
    void slotUser3();
    
    void slotIdentify();

    void slotPreviewBlinkTimerDone();
    void slotConvertBlinkTimerDone();
    
private:

    bool                              m_previewBlink;
    bool                              m_convertBlink;

    TQString                           m_inputFile;
    TQString                           m_inputFileName;
    
    TQTimer                           *m_blinkPreviewTimer;
    TQTimer                           *m_blinkConvertTimer;

    PreviewWidget                    *m_previewWidget;

    ActionThread                     *m_thread;

    SaveSettingsWidget               *m_saveSettingsBox;

    KDcrawIface::DcrawSettingsWidget *m_decodingSettingsBox;

    KIPIPlugins::KPAboutData         *m_about; 
};

} // NameSpace KIPIRawConverterPlugin

#endif // SINGLEDIALOG_H
