/***************************************************************************
*   Copyright (C) 2005 by Jason Kivlighn                                  *
*   jkivlighn@gmail.com                                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef RATING_H
#define RATING_H

#include <ntqvaluelist.h>
#include <ntqstring.h>

#include <ntqpixmap.h>

class RatingCriteria
{
public:
	RatingCriteria() : id(-1), stars(0.0){}

	int id;
	TQString name;
	double stars;
};

typedef TQValueList< RatingCriteria > RatingCriteriaList;

class Rating
{
public:
	Rating() : id(-1){}

	static TQPixmap starsPixmap( double stars_d, bool include_empty = false );

	void append( const RatingCriteria & );

	double average() const;

	int id;
	TQString comment;
	TQString rater;

	RatingCriteriaList ratingCriteriaList;
};

class RatingList : public TQValueList< Rating >
{
public:
	double average();
};

#endif
