/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEEXPRESSIONEDIT_H
#define QALCULATEEXPRESSIONEDIT_H

#include <klineedit.h>
#include <tdecompletionbox.h>
#include <kcompletion.h>
#include <tqvaluevector.h>

class TQStringList;
class TQPopupMenu;
class QalculateExpressionEditCompletionBox;
class ExpressionItem;
class TQListBoxItem;

class QalculateExpressionEdit : public KLineEdit {

	Q_OBJECT

public:

	QalculateExpressionEdit(bool connected_to_main_win, TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateExpressionEdit();

	TQValueVector<ExpressionItem*> matched_items;

	bool b_main;
	TQStringList expression_history;
	int expression_history_index;
	bool dont_change_index;
	QalculateExpressionEditCompletionBox *qalculateCompletionBox;
	TDECompletion *qalculateCompletion;

	virtual bool eventFilter(TQObject *o, TQEvent *ev);
	void keyPressEvent(TQKeyEvent *e);

public slots:

	void onTextChanged(const TQString&);
	void addToHistory(const TQString&);
	void wrapSelection();
	void makeCompletion(const TQString&);
	void insertCompletion(TQListBoxItem *li);
	void updateCompletion();
	void setAfterCompletionPosition();
	void cancelCompletion(const TQString &str);
	void setCompletedItems();
	void enableCompletion();
	void disableCompletion();
	bool completionEnabled() const;
	
signals:

	void cursorMoved();

protected:
	
	virtual TQPopupMenu *createPopupMenu();
	virtual void timerEvent(TQTimerEvent*);
	int cstart, cend, cpos_ac, prev_position, pos_timer;
	TQString completed_text;
	int pos_before_completion;

};

class QalculateExpressionEditCompletionBox : public TDECompletionBox {

	Q_OBJECT

public:

	QalculateExpressionEditCompletionBox(TQWidget *parent, const char *name = 0);
	virtual ~QalculateExpressionEditCompletionBox();
	void insertItemList(const TQValueVector<ExpressionItem*>& list, int index = -1);

public slots:

	void setItems(const TQValueVector<ExpressionItem*>& items);
	
protected:

	void hideEvent(TQHideEvent*);
	
signals:

	void hidden();
    
};


#endif
