###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### Threading support

find_package( Threads )


##### look for libqalculate

pkg_search_module( QALCULATE libqalculate )

if( NOT QALCULATE_FOUND )
   tde_message_fatal( "libqalculate is required but was not found on your system." )
endif( NOT QALCULATE_FOUND )


##### check if libqalculate requires explicitly link libcln

tde_save( CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
set( CMAKE_REQUIRED_INCLUDES ${QALCULATE_INCLUDE_DIRS} )
set( CMAKE_REQUIRED_LIBRARIES ${QALCULATE_LIBRARIES} )

check_cxx_source_compiles("
	#include <libqalculate/qalculate.h>
	int main(int argc, char **argv) { Number n; return 0; } "
	QALCULATE_LIBRARIES_WORKS
)
if( NOT QALCULATE_LIBRARIES_WORKS )
  pkg_search_module( CLN cln )
  if( NOT CLN_FOUND )
     tde_message_fatal( "libqalculate require CLN library but it was not found on your system." )
  endif( NOT CLN_FOUND )
  list( APPEND QALCULATE_LIBRARIES ${CLN_LIBRARIES} )
  message( STATUS "Added CLN_LIBRARIES to QALCULATE_LIBRARIES" )
endif( )

tde_restore( CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
