/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_ENTREZFETCHER_H
#define TELLICO_ENTREZFETCHER_H

namespace Tellico {
  class XSLTHandler;
}

#include "fetcher.h"
#include "configwidget.h"
#include "../datavectors.h"

#include <tqcstring.h> // for TQByteArray
#include <tqguardedptr.h>

namespace TDEIO {
  class Job;
}

namespace Tellico {
  namespace Fetch {

/**
 * @author Robby Stephenson
 */
class EntrezFetcher : public Fetcher {
Q_OBJECT
  

public:
  EntrezFetcher(TQObject* parent, const char* name=0);
  /**
   */
  virtual ~EntrezFetcher();

  virtual TQString source() const;
  virtual bool isSearching() const { return m_started; }
  // pubmed can search title, person, and keyword
  virtual bool canSearch(FetchKey k) const { return k == Title || k == Person || k == Keyword || k == Raw || k == PubmedID || k == DOI; }
  virtual void search(FetchKey key, const TQString& value);
  virtual void continueSearch();
  virtual void stop();
  virtual Data::EntryPtr fetchEntry(uint uid);
  virtual Type type() const { return Entrez; }
  virtual bool canFetch(int type) const;
  virtual void readConfigHook(const TDEConfigGroup& config);
  virtual void updateEntry(Data::EntryPtr entry);
  virtual Fetch::ConfigWidget* configWidget(TQWidget* parent) const;

  static StringMap customFields();

  class ConfigWidget : public Fetch::ConfigWidget {
  public:
    ConfigWidget(TQWidget* parent_, const EntrezFetcher* fetcher=0);
    virtual void saveConfig(TDEConfigGroup& config);
    virtual TQString preferredName() const;
  };
  friend class ConfigWidget;

  static TQString defaultName();

private slots:
  void slotData(TDEIO::Job* job, const TQByteArray& data);
  void slotComplete(TDEIO::Job* job);

private:
  void initXSLTHandler();
  void doSummary();

  void searchResults();
  void summaryResults();

  enum Step {
    Begin,
    Search,
    Summary,
    Fetch
  };

  XSLTHandler* m_xsltHandler;
  TQString m_dbname;

  size_t m_start;
  size_t m_total;

  TQByteArray m_data;
  TQMap<int, Data::EntryPtr> m_entries; // map from search result id to entry
  TQMap<int, int> m_matches; // search result id to pubmed id
  TQGuardedPtr<TDEIO::Job> m_job;

  TQString m_queryKey;
  TQString m_webEnv;
  Step m_step;

  bool m_started;
  TQStringList m_fields;
};

  } // end namespace
} // end namespace

#endif
