/***************************************************************************
    smb4ksharesiconview  -  This is the shares icon view of Smb4K.
                             -------------------
    begin                : Mo Dez 4 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHARESICONVIEW_H
#define SMB4KSHARESICONVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// TQt includes
#include <tqvaluelist.h>

// KDE includes
#include <kiconview.h>
#include <kurldrag.h>

// forward declarations
class Smb4KSharesIconViewItem;
class Smb4KSharesIconViewToolTip;


/**
 * This widget class provides the shares icon view of Smb4K.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KSharesIconView : public TDEIconView
{
  Q_OBJECT
  

  public:
    /**
     * The constructor.
     *
     * @param parent          The parent widget
     *
     * @param name            The name of the widget
     */
    Smb4KSharesIconView( TQWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KSharesIconView();

    /**
     * Update the tool tip if it exists. This function just executes
     * Smb4KSharesListViewToolTip::update().
     */
    void updateToolTip();

  protected:
    /**
     * Reimplemented (sort of) from TQIconView to enable dragging. As TQDragObject
     * a KURLDrag will be returned.
     *
     * @returns a KURLDrag object.
     */
    KURLDrag *dragObject();

    /**
     * Reimplemented from TQIconView to allow some actions to be carried
     * out before the drag begins.
     */
    void startDrag();

    /**
     * Reimplemented from TQIconView.
     */
    void contentsDragEnterEvent( TQDragEnterEvent * );

    /**
     * Reimplemented from TQIconView.
     */
    void contentsDragMoveEvent( TQDragMoveEvent *e );

    /**
     * Reimplemented from TQIconView.
     */
    void contentsDropEvent( TQDropEvent *e );

    /**
     * Reimplemented from TQIconView. This function is used to
     * show the tooltips.
     */
    void contentsMouseMoveEvent( TQMouseEvent *e );

  protected slots:
    /**
     * This slot is connected to TDEIconView::pressed() and clears the selection
     * if the user clicked on the viewport.
     *
     * @param item            The TQIconViewItem that the user clicked or NULL
     *                        if he/she pressed a mouse button on the viewport.
     */
    void slotPressed( TQIconViewItem *item );

    /**
     * This slot shows the tool tip for an icon view item.
     */
    void slotShowToolTip();

  private:
    /**
     * The current global mouse position
     */
    TQPoint m_pos;

    /**
     * The tool tip
     */
    Smb4KSharesIconViewToolTip *m_tooltip;
};

#endif
