/***************************************************************************
                      challenge_graph.h  -  description
                             -------------------
    begin                : Mon Jan 7 2002
    copyright            : (C) 2003 by Eric Faccer
    email                : e.faccer@qut.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHALLENGE_GRAPH_H
#define CHALLENGE_GRAPH_H

#include <tqstringlist.h>
#include <tqvbox.h>
#include <tqevent.h>
#include <tqcolor.h>

#include "resource.h"
#include "challenge_game.h"

class TDEPopupMenu;
class TQCanvas;
class TQLabel;
class Challenge_Graph_View;
class Command;

class Challenge_Graph : public TQVBox
{
	Q_OBJECT
  

	public:
										Challenge_Graph(TQWidget *parent=0, const char *name=0, resource *Rsrc=0);
		virtual					~Challenge_Graph();
		void						resizeEvent( TQResizeEvent* );
		void						add( Challenge_Game *seek );
		void						clear();

	signals:
		void						sendCMD( const Command& );

	public slots:
		void						recvCMD( const Command& );
		void						display_menuSeek( Challenge_Game*, const TQPoint& );
		void						selectMatch( int );
		void						menuFunct( int );

	protected:
		virtual bool		isEmpty( int x, int y );
		void						drawChallenge( int time_control_x, int rating_y, bool rated, Challenge_Game *challenge );
		bool						addTo_Nearest_Neighbour( int orig_x, int orig_y, bool rated, Challenge_Game *challenge, int searchdepth=10 );
		void						createBackground( void );
		void						addSoughtItem( const TQString& );
		void						updateSoughtList( void );

	private:
		int x_size;
		int y_size;
		int max_rating;
		int max_time;
		bool seek;

		resource							*myResource;
		TQCanvas								*graph;
		Challenge_Graph_View	*myView;
		TQLabel								*myStatusBar;
		TQPixmap								background;

		TDEPopupMenu			*menuSeek;
		int							selectedMatchID;
		TQString					selectedPlayerName;
		/*
				These StringLists temporarily store Sought Game data
				until all ads have been displayed.
		*/
		TQStringList			SF_01;
		TQStringList			SF_02;
		TQStringList			SF_03;
		TQStringList			SF_04;
		TQStringList			SF_05;
		TQStringList			SF_06;
		TQStringList			SF_07;
};

#endif

