/* This file is part of the KDE project
   Copyright (C) 2001 Andrea Rizzi <rizzi@kde.org>
	              Ulrich Kuettler <ulrich.kuettler@mailbox.tu-dresden.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef kfconfigpages_h
#define kfconfigpages_h

#include <tqfont.h>
#include <tqvaluevector.h>

#include <kdialogbase.h>

#include "kformuladefs.h"

class TQButtonGroup;
class TQCheckBox;
class TQColor;
class TQGridLayout;
class TQLabel;
class TQPushButton;
class TQSpinBox;
class TQStringList;
class TQWidget;

class KColorButton;
class TDEConfig;
class TDEListView;
class KPushButton;
class KIntNumInput;

KFORMULA_NAMESPACE_BEGIN


class Document;

class KOFORMULA_EXPORT ConfigurePage : public TQObject
{
    Q_OBJECT
  
public:

    ConfigurePage( Document* document, TQWidget* view, TDEConfig* config, TQVBox* box, char* name = 0 );
    void apply();
    void slotDefault();

protected:

    bool selectFont( TQFont & );

protected slots:

    void syntaxHighlightingClicked();
    void selectNewDefaultFont();
    void selectNewNameFont();
    void selectNewNumberFont();
    void selectNewOperatorFont();

    void baseSizeChanged( int value );
    void slotChanged();

private:

    TQPushButton* buildFontLine( TQWidget* fontWidget, TQGridLayout* layout, int number,
                                TQFont font, TQString name, TQLabel*& fontName );

    void updateFontLabel( TQFont font, TQLabel* label );

    Document* m_document;
    TQWidget* m_view;
    TDEConfig* m_config;

    TQFont defaultFont;
    TQFont nameFont;
    TQFont numberFont;
    TQFont operatorFont;

    KIntNumInput* sizeSpin;

    TQLabel* defaultFontName;
    TQLabel* nameFontName;
    TQLabel* numberFontName;
    TQLabel* operatorFontName;

//     KColorButton* defaultColorBtn;
//     KColorButton* numberColorBtn;
//     KColorButton* operatorColorBtn;
//     KColorButton* emptyColorBtn;
//     KColorButton* errorColorBtn;
    TQCheckBox* syntaxHighlighting;

    bool m_changed;
};


// class MathFontsConfigurePage : public TQObject
// {
//     Q_OBJECT
//     
// public:

//     MathFontsConfigurePage( Document* document, TQWidget* view, TDEConfig* config, TQVBox* box, char* name = 0 );
//     void apply();
//     void slotDefault();

//     TQValueVector<TQString>::iterator findUsedFont( TQString name );

// protected slots:

//     void slotAddFont();
//     void slotRemoveFont();
//     void slotMoveUp();
//     void slotMoveDown();

// private:

//     void setupLists( const TQStringList& usedFonts );

//     Document* m_document;
//     TQWidget* m_view;
//     TDEConfig* m_config;

//     TDEListView* availableFonts;
//     TDEListView* requestedFonts;

//     KPushButton* addFont;
//     KPushButton* removeFont;
//     KPushButton* moveUp;
//     KPushButton* moveDown;

//     TQValueVector<TQString> usedFontList;
// };


KFORMULA_NAMESPACE_END

#endif // kfconfigpages_h
