/* This file is part of the KDE project
   Copyright (C) 2002-2003 Norbert Andres <nandres@web.de>
             (C) 2002 John Dailey <dailey@vt.edu>
             (C) 2001-2002 Philipp Mueller <philipp.mueller@gmx.de>
             (C) 1999-2005 Laurent Montel <montel@kde.org>
             (C) 1998-1999 Torben Weis <weis@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __kspread_dlg_validity__
#define __kspread_dlg_validity__

#include <kdialogbase.h>

#include "kspread_cell.h"

class TQLabel;
class TQLineEdit;
class TQTextEdit;
class TQComboBox;
class TQPushButton;
class TQCheckBox;

namespace KSpread
{
class Sheet;
class View;

class DlgValidity : public KDialogBase
{
  Q_OBJECT
  
public:
DlgValidity(View* parent, const char* name ,const TQRect &_marker );
void init();

public slots:
 void OkPressed();
 void clearAllPressed();
 void changeIndexCond(int);
 void changeIndexType(int);
protected:
    void displayOrNotListOfValidity( bool _displayList);

  View* m_pView;
  TQRect  marker;
  TQLineEdit *val_max;
  TQLineEdit *val_min;
  TQLabel *edit1;
  TQLabel *edit2;
  TQComboBox *choose;
  TQComboBox *chooseAction;
  TQComboBox *chooseType;
  TQLineEdit * title;
  TQTextEdit *message;
  Validity result;
  TQCheckBox *displayMessage;
  TQCheckBox *allowEmptyCell;
    TQCheckBox *displayHelp;
    TQTextEdit *messageHelp;
    TQLineEdit *titleHelp;
    TQTextEdit *validityList;
    TQLabel *validityLabelList;
};

} // namespace KSpread

#endif
