/***************************************************************************
 *   Copyright (C) 2005-2006 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef DEVICE_EDITOR_H
#define DEVICE_EDITOR_H

#include "editor.h"
namespace Device { class Data; }

class DeviceEditor : public Editor
{
Q_OBJECT
  
public:
  DeviceEditor(const TQString &title, const TQString &tag, TQWidget *parent, const char *name);
  DeviceEditor(TQWidget *parent, const char *name);
  virtual PURL::FileType fileType() const { return PURL::Nb_FileTypes; }
  virtual PURL::Url url() const { return PURL::Url(); }
  virtual void setDevice(bool force = false);
  static TQString guessDeviceFromFile(const PURL::Url &url);
  virtual bool save(const PURL::Url &) { return false; }
  virtual bool open(const PURL::Url &) { return true; }
  virtual TQValueList<uint> bookmarkLines() const { return TQValueList<uint>(); }
  virtual void setBookmarkLines(const TQValueList<uint> &) {}

public slots:
  virtual void statusChanged() { emit statusTextChanged("  "); }

protected:
  TQString      _device;
  TQWidget     *_widget, *_view;
  TQVBoxLayout *_top, *_vbox;
  TQLabel      *_labelDevice, *_labelWarning;

  void init();
  virtual TQWidget *createView(const Device::Data *data, TQWidget *parent) = 0;
  static PURL::Url findAsmFile(const PURL::Url &url);

private slots:
  void updateDevice() { setDevice(); }
};

#endif
