/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _KLAMAV_H_
#define _KLAMAV_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeapplication.h>
#include <tdemainwindow.h>
#include <tqtabwidget.h>

#include <stdlib.h>

class KPrinter;
class TDEToggleAction;
class TDEPopupMenu;
class KURL;
class TQLineEdit;
class TQComboBox;
class TQCheckBox;
class TQListBox;
class TQPushButton;
class TQLabel;
class TDEProcess;
class TDEConfig;
class KURLRequester;
class Freshklam;
class Sigtool;
class Klamscan;
class KlamavDock;
class Kuarantine;
class Activityviewer;
class Aboutklamav;
class KlamDB;
class KSystemTray;
class KlamOnAcc;

/**
 * This class serves as the main window for Klamav.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Klamav : public TDEMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Klamav();

    /**
     * Default Destructor
     */
    virtual ~Klamav();

    /**
     * Use this method to load whatever file/URL you have
     */
    void  setDirName(TQString);

    KlamavDock *m_dock;
    KSystemTray *_tray;
    TDEAction *EnableFreshklam;
    TDEAction *DisableFreshklam;
    TDEAction *EnableKlamOnAcc;
    TDEAction *DisableKlamOnAcc;
    Freshklam *freshklam;
    bool firstDownload;
    bool downloadDBForWizard;
    Kuarantine *kuarantine;
    KlamDB *klamdb;
    Klamscan *klamscan;
    Activityviewer *activityviewer;
    void showVirusBrowser();
    TQTabWidget *tab;
    KlamOnAcc *klamonacc;


protected:
    /**
     * Overridden virtuals for TQt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(TQDragEnterEvent *event);
    virtual void dropEvent(TQDropEvent *event);*/
	virtual bool queryClose();


protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(TDEConfig *);

    /**
     * This function is called when this app is restored.  The TDEConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(TDEConfig *);

public slots:
	void slotConfigKlamav( const TQCString& page );
private slots:
	void slotScanFile();
	void slotScanDir();
	void slotScheduleScan();
	void slotOptions();
	void slotToggleWelcome();
	void slotToggleQuarantine();
	void slotToggleDBViewer();
	void slotToggleEvents();
  void slotKOAStateUpdate();
	void contextEnableFK();
  void contextUpdateFK();
  void contextDisableFK();
  void contextEnableKOA();
  void contextDisableKOA();
	void tabClosed(TQString name);

private:
    void setupAccel();
    void setupActions();
    void firstRunWizard();
    void createDefaultKlamAVDir(TQString type);
    void checkDir(TQString path);
    void updateTabState(int tabId, bool init);

private:
    //KlamavView *m_view;



signals:
    void itemSelected(TQString abs_filename, int line);

public slots:
private slots:
    void shuttingDown();
private:
    void processOutput();
    void finish();
    void getout();

    TQLineEdit *template_edit;
    TQComboBox *files_combo, *pattern_combo/*, *dir_combo*/;
    KURLRequester *dir_combo;
    TQCheckBox *recursive_box;
    TQListBox *resultbox;
    TQPushButton *search_button, *cancel_button;
    TQLabel *status_label, *matches_label;
    TDEProcess *childproc;
    TQString buf;
    TDEConfig* config;
    TQStringList lastSearchItems;
    TQStringList lastSearchPaths;
    Sigtool *sigtool;
    Aboutklamav *aboutklamav;

    TDEPopupMenu *tabs_menu;
    int showWelcomeTab;
    int showQuarantineTab;
    int showDBViewerTab;
    int showEventsTab;
};

extern Klamav *tdemain;

#endif // _KLAMAV_H_
