/***************************************************************************
 *     Copyright (C) 2004 by Sashmit Bhaduri                               *
 *     smt@vfemail.net                                                     *
 *                                                                         *
 *     Licensed under GPL.                                                 *
 ***************************************************************************/

#ifndef FRAME_H
#define FRAME_H

#include <tdeparts/part.h>

#include <tqobject.h>

namespace KPIM
{
    class ProgressItem;
}

namespace KlamAV
{

    class Frame : public TQObject
    {
        Q_OBJECT

        public:
            Frame(TQObject *parent, KParts::ReadOnlyPart *part, TQWidget *w, const TQString& tit, bool watch=true);
            ~Frame();

            enum {Idle, Started, Completed, Canceled};

            KParts::ReadOnlyPart *part() const;
            TQWidget *widget() const;
            const TQString title() const;
            const TQString caption() const;
            int state() const;
            int progress() const;
            const TQString statusText() const;

        public slots:
            void setStarted();
            void setCanceled(const TQString &);
            void setCompleted();
            void setState(int);
            void setProgress(int);
            void setCaption(const TQString &);
            void setTitle(const TQString &);
            void setStatusText(const TQString &); 

        signals:
            void captionChanged(const TQString &);
            void started();
            void canceled(const TQString &);
            void completed();
            void loadingProgress(int);
            void statusText(const TQString &);

        private:
            KParts::ReadOnlyPart *m_part;
            TQWidget *m_widget;
            TQString m_title;
            TQString m_caption;
            int m_state;
            int m_progress;
            TQString m_statusText;
            TQString m_progressId;
            KPIM::ProgressItem *m_progressItem;
    };
}

#endif
