/***************************************************************************
begin                : 2004/02/07
copyright            : (C) Mark Kretschmann
email                : markey@web.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLAMAVCONFIGDIALOG_H
#define KLAMAVCONFIGDIALOG_H


#include <tqmap.h>
#include <tqvaluelist.h>

#include <tdeconfigdialog.h>

class TQComboBox;
class TQGroupBox;
class TQVBox;


class KlamavConfigDialog : public TDEConfigDialog
{
    Q_OBJECT

    public:
        KlamavConfigDialog( TQWidget *parent, const char* name, TDEConfigSkeleton *config );
        ~KlamavConfigDialog();

        void addPage( TQWidget *page, const TQString &itemName, const TQString &pixmapName,
                      const TQString &header=TQString::null, bool manage=true);

        void showPage( const TQCString& page );

    public slots:
        void slotToggleClamdscan( bool on );
        void slotToggleKlamOnAcc( bool on );
        void slotToggleKlamOnAccCheckbox();

    private:
        bool clamdscan;

	class KlamBackend *m_klambackend;
        class ArchiveOptions  *m_archives;
        class SpecialFileTypes     *m_specialfiletypes;
	class Sigtool	*m_emailprotection;
	class KlamOnAccConfig *m_klamonacc;
	class LogOptions     *m_logoptions;

        TQValueList<TQWidget*> m_pageList;
        TQMap<TQString, TQString> m_pluginName;
        TQMap<TQString, TQString> m_pluginKlamavName;

    private slots:
        void applySettings();
};


#endif // KLAMAVCONFIGDIALOG_H
