/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */
#include <config.h>


#include "activityviewer.h"
#include "dbviewer.h"
#include "klamav.h"
#include "klamavconfig.h"
#include "collectiondb.h"


#include <tdelocale.h>
#include <kiconloader.h>
#include <tdemenubar.h>
#include <kstatusbar.h>
#include <kkeydialog.h>
#include <tdeio/netaccess.h>
#include <tdefiledialog.h>
#include <kdebug.h>
#include <tdelistviewsearchline.h>
#include <tdetoolbarbutton.h> //ctor


#include <kbuttonbox.h>
#include <kurlrequester.h>
#include <kurlcompletion.h>
#include <kcombobox.h>
#include <tqlayout.h>
#include <tdemessagebox.h>
#include <kstandarddirs.h>
#include <tqtoolbutton.h>

const char *log_type[] = {
    "All Types",
    "Launch",
	"Shutdown",
    "Manual Scan",
	"Error Found",
	"Virus Found",
    "Auto-Scan",
    "Updates",
    "Quarantine",
    0
};

const char *log_days[] = {
    "Last 1 Day",
    "Last 2 Days",
    "Last 7 Days",
    "Last 14 Days",
    "Last 31 Days",
    "Last 62 Days",
    "Last 365 Days",
    0
};


Activityviewer::Activityviewer(TQWidget *parent, const char *name)
    : TQWidget(parent, name)
{

	//Create GUI	

	TQVBoxLayout *vbox = new TQVBoxLayout(this, KDialog::marginHint(),
			KDialog::spacingHint(), "vbox");

 	TQWidget* privateLayoutWidget2 = new TQWidget( this, "dblayout" );

	TQGridLayout *layout = new TQGridLayout(privateLayoutWidget2, 2, 6, 10, 4);

	TQLabel *combo_label = new TQLabel(i18n("Display Event Type:"), privateLayoutWidget2);
	//combo_label->setFixedSize(combo_label->sizeHint());
	layout->addWidget(combo_label,0,0);
        combo_label->adjustSize();

	check_combo = new TQComboBox(false, privateLayoutWidget2);
	check_combo->insertStrList(log_type);
	check_combo->adjustSize();
	//check_combo->setFixedSize(check_combo->size());
	layout->addWidget(check_combo,0,1);

	TQLabel *days_label = new TQLabel(i18n(" from the "), privateLayoutWidget2);
	//combo_label->setFixedSize(combo_label->sizeHint());
	layout->addWidget(days_label,0,2);
        days_label->adjustSize();

	days_combo = new TQComboBox(false, privateLayoutWidget2);
	days_combo->insertStrList(log_days);
	days_combo->adjustSize();
	//check_combo->setFixedSize(check_combo->size());
	layout->addWidget(days_combo,0,3);
	


 	TQToolButton* options = new TQToolButton( privateLayoutWidget2,"play" );
 	options->setIconSet( SmallIconSet( "configure" ) );
	options->setTextLabel("Options");
	options->setTextPosition(TQToolButton::Right);
	options->setUsesTextLabel(true);
 	options->adjustSize();
 	layout->addWidget(options,0,6);

	vbox->addWidget(privateLayoutWidget2);
 	connect( options, SIGNAL(clicked()), SLOT(slotOptions()) );



	TQGroupBox *group2 = new TQGroupBox(i18n("Activity"), this);
	vbox->addWidget(group2);

	TQGridLayout *layout2 = new TQGridLayout( group2, 1, 1, KDialog::spacingHint(),	KDialog::spacingHint(), "layout2");
	layout2->addRowSpacing(0, group2->fontMetrics().height());
	layout2->addRowSpacing(1, group2->fontMetrics().height());
	//layout2->setColStretch(0, 1);
	//layout2->setColStretch(1, 1);

	TQWidget *hlp2 = new TQWidget( group2 );
	layout2->addMultiCellWidget(hlp2, 1,1, 0,0);
	TQVBoxLayout *dir_layout2 = new TQVBoxLayout(hlp2, KDialog::spacingHint() );



	TDEToolBarButton *button;
	TDEToolBar* searchToolBar = new TDEToolBar( hlp2 );
	searchToolBar->setMovingEnabled(false);
	searchToolBar->setFlat(true);
	searchToolBar->setIconSize( 16 );
	searchToolBar->setEnableContextMenu( false );

	button = new TDEToolBarButton( "locationbar_erase", 0, searchToolBar );
        /*TQLabel *filter_label =*/ new TQLabel( i18n("Search:") + " ", searchToolBar );


	currentbox = new TDEListView(hlp2);
        currentbox->setShowSortIndicator(true);
    
	TQFontMetrics rb_fm(currentbox->fontMetrics());
	//currentbox->setMinimumSize(rb_fm.width("0")*55,
	//			rb_fm.lineSpacing()*15);
	////kdDebug() << ((currentbox->width())/3) << endl;
	currentbox->addColumn( "Date",0);
	currentbox->addColumn( "Type",0);
        currentbox->addColumn( "Event",0);
        currentbox->addColumn( "File",0);
	currentbox->setResizeMode(TQListView::AllColumns);
	currentbox->setSelectionMode( TQListView::Extended );
	currentbox->setAllColumnsShowFocus(true);

// 	qmenu = new TQPopupMenu( currentbox );

//     	connect(currentbox, SIGNAL( contextMenuRequested( TQListViewItem *, const TQPoint& , int ) ), 
// 		this, SLOT( slotRMB( TQListViewItem *, const TQPoint &, int ) ) );

	kLineEdit1 = new TDEListViewSearchLine( (TQWidget *)searchToolBar, currentbox,"klinedit1");
/*	TQValueList<int> columns;
        columns.append(0);
	columns.append(1);
	columns.append(2);*/
/*	kLineEdit1->setSearchColumns();*/
	//kLineEdit1->setMaxLength(2);
	connect(button, SIGNAL( clicked() ),
	                kLineEdit1, SLOT(clear()) );
	connect(check_combo, SIGNAL( activated(const TQString &) ),
	                this, SLOT(allActivityOfType(const TQString &) ));
	connect(days_combo, SIGNAL( activated(const TQString &) ),
	                this, SLOT(allActivityOfDate(const TQString &) ));


        searchToolBar->setStretchableWidget( kLineEdit1 );

	dir_layout2->addWidget( searchToolBar,0,0);

	dir_layout2->addWidget(currentbox,1,0);
	
	//layout->addMultiCellWidget(currentbox);

	CollectionDB::instance()->expireActivity( TQString("%1").arg(KlamavConfig::expireDays()) );

 	allActivityOfDate(days_combo->currentText());
	

}

void Activityviewer::populateActivity()
{

	currentbox->clear();

	if (!(activity.isEmpty())){

		int i=0;
		TQString eventdate;
		TQString eventtype;
		TQString event;
		TQString file;
		for (TQStringList::Iterator it = activity.begin(); it != activity.end(); it++ ){
			////kdDebug() << *it << endl;
			if (i==0){
				eventdate = *it;
				i++;
			}else if (i==1){
				eventtype = i18n(it->ascii());
				i++;
			}else if (i==2){
				event = i18n(it->ascii());
				i++;
			}else if (i==3){
				file = *it;
				i=0;
				new EventListItem( currentbox, eventdate, eventtype,event, file);
			}
		}
	}
}

void Activityviewer::allActivity()
{

	activity = CollectionDB::instance()->allActivity();

	populateActivity();	
}

void Activityviewer::allActivityOfType(const TQString &type)
{


	TQString days = days_combo->currentText().remove("Last ").remove(" Days").remove(" Day");

	activity = CollectionDB::instance()->allActivityOfType(type,days);

	populateActivity();	
}

void Activityviewer::allActivityOfDate(const TQString &days)
{
	TQString stripdays = days;
	stripdays = stripdays.remove("Last ").remove(" Days").remove(" Day");
	TQString type = check_combo->currentText();

	activity = CollectionDB::instance()->allActivityOfType(type,stripdays);

	populateActivity();	
}

void Activityviewer::insertItem(const  TQString &date, const  TQString &type, const TQString &event, const TQString &file)
{

    if ((check_combo->currentText() == type) || (check_combo->currentText() == "All Types"))
        new EventListItem( currentbox, date, type, event, file);

}

void  Activityviewer::slotOptions(){

	
	tdemain->slotConfigKlamav( "Event Logging" );	

}


Activityviewer::~Activityviewer()
{
}

EventListItem::EventListItem( TDEListView *parent, TQString label1, TQString label2 , TQString label3, TQString label4)
    : TDEListViewItem( parent, label1, label2 , label3, label4 )
{
}
 
EventListItem::~EventListItem()
{
}


// paint ze peons
void EventListItem::paintCell ( TQPainter * p, const TQColorGroup & cg, int column, int width, int align )
{
    	TQColorGroup cg2(cg);
    

	if (( this->text(1).contains( "Virus")) || ( this->text(1).contains( "Error")))
		cg2.setColor(TQColorGroup::Text, TQt::red);
	else if ( this->text(1) == "Updates")
		cg2.setColor(TQColorGroup::Text, TQt::blue);
	else if ( this->text(1) == "Quarantine")
		cg2.setColor(TQColorGroup::Text, TQt::green);

    	TDEListViewItem::paintCell( p, cg2, column, width, align );

}



#include "activityviewer.moc"
