/***************************************************************************
                          qlcdstring.cpp  -  description
                             -------------------
    begin                : Sat Jul 21 2001
    copyright            : (C) 2001 by Michael
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "qlcdstring.h"

#include <ntqpalette.h>


TQLCDString::TQLCDString( TQWidget *parent, const char *name ): TQWidget( parent, name )
{
 digitStr= "";
 options= TQLcd::alignCenter;

 TQColorGroup g= colorGroup();
 forColor= g.foreground();
 shaColor= g.shadow();
}


TQLCDString::~TQLCDString(){
}

void TQLCDString::display( const TQString &str )
{
  digitStr= str;
  update();
}


void TQLCDString::setAlign(Align newAlign)
{
 if( (options & TQLcd::alignMask)!=newAlign ) {
   options= (options & ~TQLcd::alignMask ) | newAlign;
   update();
 }
}

const TQColor& TQLCDString::foreColor()
{
 return forColor;
}

const TQColor& TQLCDString::shadowColor()
{
 return shaColor;
}


void TQLCDString::setForeColor(const TQColor &fore)
{
  forColor= fore;
  update();
}

void TQLCDString::setShadowColor(const TQColor &sha)
{
 shaColor= sha;
 update();
}


void TQLCDString::resizeEvent ( TQResizeEvent *)
{
 update();
}


void TQLCDString::setShadow(bool enable)
{
 if( (bool)(options & TQLcd::drawShadow) != enable ) {
   options^= TQLcd::drawShadow;
   update();
 }
}


void TQLCDString::setNumberDisplay(bool enable)
{
 if( (bool)(options & TQLcd::drawNumber) != enable ) {
   options^= TQLcd::drawNumber;
   update();
 }
}


void TQLCDString::paintEvent( TQPaintEvent *e )
{
TQPainter p(this);

 TQLcd::draw(&p,0,0,width(),height(),digitStr.latin1(),options,&forColor,&shaColor);
}

#include "qlcdstring.moc"
