/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_PLASMA_PLUGIN_LOADER_H
#define KBFX_PLASMA_PLUGIN_LOADER_H

#include <tqlibrary.h>
#include "kbfxplasmacanvasstack.h"
#include "kbfxdatastack.h"
#include "kbfxplugin.h"
#include <tqcanvas.h>

class KbfxPlasmaPluginLoader:public TQObject
{
		Q_OBJECT
  

	public:
		typedef TQMap<TQString,KbfxPlugin*> PluginMap;

		/**
		 * 
		 * @return 
		 */
		KbfxPlasmaPluginLoader();
		/**
		 * 
		 * @return 
		 */
		~KbfxPlasmaPluginLoader();
		/**
		 * 
		 * @param name 
		 * @return 
		 */
		KbfxDataStack * getView ( TQString name );
		/*
		look for all installed Plugins. returns a list of installed plugins
		*/
		static TQStringList scanPlugins();

		/**
		 * Calls the search function of a given plugin and returns the result
		 * @param pluginName The name of the plugin to call 
		 * @param keyword the keyword to pass to the plugin
		 * @return a valid KbfxDataGroup or -1 
		 */
		static KbfxDataGroup * search ( TQString pluginName,TQString keyword );

	protected:
		static	void init();

	private:

		TQLibrary * m_plugin;
		static  PluginMap& pluginMap();
		TQString m_prefix;


};

#endif
