/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef __UTILS_H____
#define __UTILS_H____

#include <tqobject.h>
#include <tqprocess.h>
#include <tqvaluelist.h>
#include "kvpncconfig.h"
#include "kvpnc.h"
#include "toolinfo.h"
#include <tqstringlist.h>
#include <tdetempfile.h>

/**
Provides various help functions.
 
@author Christoph Thielecke
*/
class Utils : public TQObject
{
	Q_OBJECT
  
public:
	Utils(KVpncConfig* config,TQObject *parent = 0, const char *name = 0);

	~Utils();

	bool isValidIPv4Address(TQString Address);
	bool isValidIPv4NetworkAddress(TQString Address);
	bool isValidIPv4BroadcastAddress(TQString Address);
	bool isValidIPv4Netmask(TQString Netmask);
	bool tunDevExists();
	bool createTunDev();
	bool loadKernelModule(TQString Name,TQApplication *app);
	bool unloadKernelModule(TQString Name,TQApplication *app, bool force=true);
	bool doChmod(TQString file, TQString mode);
	bool resolvConfAvailable();
	TQStringList getOpenvpnCiphers();
	TQStringList getOpenvpnDigests();
	TQPtrList<ToolInfo>* getToolList();
	ToolInfo* getToolInfo( TQString name);
	TQString resolveName(TQString Name);
	TQString removeSpecialCharsForFilename(TQString filename);
	TQString getNameAndPidOfProgramListen(int port);
	TQString getEmailAddressOfCert(TQString cert);
	TQString getHostname();
	TQStringList getSmartcardSlots(TQString ProviderLib);
	TQStringList getSmartcardCertsFromSlot(TQString slot,TQString IdType,TQString ProviderLib);
	TQStringList getOpenvpnPkcs11Ids(TQString ProviderLib);
	bool getNeedsPassphrase(TQString key);
	TQStringList getCertsFromCiscoCertStore(TQString type="user");
	TQString dec2bin(int n);
	int dottedIpv4Netmask2NetmaskBytes(TQString dottedIpv4Netmask);
	TQString IpsecAlgoCurrent;
	struct IpsecAlgos {
		TQStringList IpsecIkeEncryptionAlgorithms;
		TQStringList IpsecIkeHashAlgorithms;
		TQStringList IpsecIkeDhGroups;
		TQStringList IpsecEspEncryptionAlgorithms;
		TQStringList IpsecEspAuthenticationAlgorithms;
		TQStringList IpsecCompressionAlgorithms;
	};

	struct PppdCapabilities {
		bool pppdHasMppeRequiredSupport;
		bool pppdHasRequireMppeSupport;
		bool pppdHasReplacedefaultrouteSupport;

		/* options for pppd depending on pppd version */

		// MPPE
		TQString RequireMppeOption;
		TQString Require128BitMppeOption;
		TQString RefuseMppeOption;
		TQString Refuse40BitMppeOption;
		TQString Refuse128BitMppeOption;
		TQString RequireStatelessOption;
		TQString RequireStatefulOption;
		bool MppeOptionsInALine; // older pppd need all in one line

		// AUTH
		TQString RequireAuthChapOption;
		TQString RequireAuthMschapOption;
		TQString RequireAuthMschapv2Option;
		TQString RequireAuthPapOption;

		bool pppdHasMppeSupport; //< true if pppd has mppe support
		bool oldPppdStyle; //< true if old style was found ('mppe require')
		bool pppdOk; // if pppd could started
	};

	struct IpsecAlgos getKernelCrypto();
	struct IpsecAlgos getIpsecAlgos();
	struct PppdCapabilities checkPppdCapabilities();

public slots:
	void readStdOutCreateTunDev();
	void readStdErrCreateTunDev();
	void readStdOutLoadKernelModule();
	void readStdErrLoadKernelModule();
	void readStdOutToolsTest();
	void readStdErrToolsTest();
	void readStdOutRetriveOpenvpnCiphers();
	void readStdErrRetriveOpenvpnCiphers();
	void readStdOutRetriveIpsecAlgos();
	void readStdErrRetriveIpsecAlgos();
	void readStdOutRetriveOpenvpnDigests();
	void readStdErrRetriveOpenvpnDigests();
	void readStdOutGetNameAndPidOfProgramListen();
	void readStdErrGetNameAndPidOfProgramListen();
	void readOutGetEmailAddressOfCert();
	void readOutGetSmartcardSlots(TDEProcess *   proc, char *   buffer, int   buflen);
	void readOutGetSmartcardCertsFromSlot();
	void readOutGetOpenvpnPkcs11Ids();
	void readOutNeedsPassphrase();
	void readOutGetCertsFromCiscoCertStoreSlot();
	void readPppdtestProcessOutput();
	void readStdOutGetHostname();
	void readStdErrGetHostname();
	

private:
	bool modprobeSuccess;
	bool toolsTestSuccess;
	bool retrieveOpenvpnCiphers;
	bool retrieveOpenvpnDigests;
	bool retrieveIpsecAlgos;
	bool retrieveNameAndPidOfProgramListen;
	bool retrieveHotsname;
	bool needsPassphrase;
	bool testPppdReplacedefaultroute;
	bool testPppdRequireMppe128;
	bool testPppdMppeRequiredSupport;
	bool testPppdNomppeStatefulSupport;
	bool testPppdStatelessSupport;
	bool testOldPppdStyle;
	bool testPppdRequireMppe;
	bool testPppdMppeRequired;
	
	TQString tooltest_logfile;
	TQProcess *ModprobeProcess;
	TQProcess *createProcess;
	TQProcess *NetworkDeviceTestProcess;
	TQProcess *toolsTestProcess;
	TQProcess *OpenvpnCiphersProcess;
	TQProcess *OpenvpnDigestProcess;
	TQProcess *NameAndPidOfProgramListenProcess;
	TQProcess *GetEmailAddressOfCertProcess;
	TDEProcess *GetSmartcardSlotsProcess;
	TQProcess *GetSmartcardCertsFromSlotProcess;
	TQProcess *OpenvpnPkcs11IdsProcess;
	TQProcess *GetCertsFromCiscoCertStoreProcess;
	TQProcess *NeedsPassphraseProcess;
	TQProcess *IpsecAlgosProcess;
	TQProcess *TestPppdProcess;
	TQProcess *GetHostnameProcess;
	
	TQString resolvedIP;
	bool resolveFinished;
	TQValueList<TQHostAddress> list;
	TQStringList *env;
	KVpncConfig *config;
	KTempFile *tmpfile;
	bool retrieveValidNetworkdevice;
	bool Pkcs11CertFound;
	TQStringList OpenvpnCiphers;
	TQStringList OpenvpnDigests;
	TQStringList KernelCrypto;
	TQString NameAndPidOfProgramListen;
	TQString EmailAddressOfCert;
	TQString OpenvpnDigestString;
	TQString IdType;
	TQString Hostname;
	TQStringList SmartcardSlots;
	TQStringList SmartcardCertsFromSlot;
	TQStringList CertsFromCiscoCertStore;
	TQStringList OpenvpnPkcs11Ids;

	int CertsFromCiscoCertPos;
	int ListenPort;
	int OpenvpnDigestCount;
	PppdCapabilities pppdcap;
};

#endif
