/***************************************************************************
                           kxearchiveextssettings.h
                           ------------------
    begin                : Tue Dec 02 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXEARCHIVEEXTSSETTINGS_H
#define KXEARCHIVEEXTSSETTINGS_H

#include "kxesettings.h"

#include <tqstringlist.h>

class KXEArchiveExtsSettingsPage;

/**
 * This class represents the group of configuration settings for the
 * archive extensions.
 *
 * @author Olaf Hartig
 */
class KXEArchiveExtsSettings : public KXESettings
{
		Q_OBJECT

	public:

		KXEArchiveExtsSettings( TQObject * pParent = 0, const char * pszName = 0 );

		// The following function(s) can be used to access this object's settings.
		const TQStringList & extensions() const { return m_lstExtensions; }

		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQString dialogPageName() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQString dialogPageHeader() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQString dialogPageIcon() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual TQWidget * dialogPage( TQFrame * pParent );

	protected:

		/**
		 * Derived from @ref KXESettings
		 */
		virtual void write( TDEConfig * ) const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void read( const TDEConfig * );
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void setFromPage();
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void updatePage() const;

		// the settings itself
		TQStringList m_lstExtensions;

		/**
		 * the corresponding configuration dialog page
		 * It is created on demand by @ref dialogPage.
		 */
		KXEArchiveExtsSettingsPage * m_pDialogPage;

	protected slots:

		// The following slots contain additional functionality
		// for the corresponding configuration dialog page.

		/**
		 * Copies the selected item's extension to the editline.
		 */
		void slotPageEditExtension( const TQString & );
		/**
		 * Creates a new (empty) item/ extension in the listbox and selects it.
		 */
		void slotPageAddExtension();
		/**
		 * Removes the currently selected item / extension from the listbox.
		 */
		void slotPageDeleteExtension();
		/**
		 * Copies the lineedit's current text to the currently selected item.
		 */
		void slotPageUpdateExtension( const TQString & );

};

#endif
