/***************************************************************************
                          actions.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ACTIONS_H
#define ACTIONS_H

#include <tdeaction.h>
#include <tqlabel.h>
class TQComboBox;

/**
  *@author Lumir Vanek
  */

class KXmlEditorComboAction : public TDEAction
{
  Q_OBJECT
public:
	KXmlEditorComboAction(const TQString& text, int accel, const TQObject *receiver, const char *member, TQObject* parent, const char* name);
	~KXmlEditorComboAction();

    virtual int plug(TQWidget *w, int index = -1);

    virtual void unplug(TQWidget *w);

    /** Returns the text from the combobox' editline (@ref TQComboBox::currentText). */
    TQString currentText() const;

    /** Returns the current pixmap or 0, if there isn't any (see @ref TQComboBox::pixmap). */
    const TQPixmap * currentPixmap() const;

    /**
     * Inserts the given item as the first.
     * Deletes the old entry, if the item was already in the list.
     */
    void insertItem( const TQPixmap & pixmap, const TQString & text );

    /** Tries to remove the item with the given text. */
    void removeItem( const TQString & text );

    /** returns combo box */
    TQComboBox *comboBox();

public slots:
    /** Clears the whole combobox using @ref TQComboBox::clear. */
    void slotClear();
    /** Clears the combobox' editline. */
    void slotClearEdit();
    /** Gives focus to the combobox' editline. */
    void slotFocusEdit();

protected:
    /**
     * Tries to find an item with the given text. If it finds it,
     * the items id is returned, otherwise -1.
     */
    virtual int findItem( const TQString & text );

private:
    const TQObject *m_receiver;
    const char *m_member;
    TQComboBox * m_pCombo;
};


class ToolbarLabel : public TQLabel
{
    Q_OBJECT
public:
    ToolbarLabel( const TQString & text );
};


#endif
