/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_DBUS_H
#define KNETWORKMANAGER_CONNECTION_DBUS_H

#include <hal/libhal.h>
#include <stdint.h>
#include <tqhostaddress.h>
#include <tqmap.h>
#include <tqvariant.h>
#include <tqobject.h>

#include "knetworkmanager-connection_setting.h"
#include "dbus/connection.h"
#include "dbus/connectionnode.h"

class TQT_DBusObjectPath;

namespace ConnectionSettings
{

	class ConnectionInterface;
	class ConnectionSetting;
	class ConnectionDBusPrivate;

	// DBUS abstraction for a connection
	class ConnectionDBus : public TQObject, public DBus::ConnectionInterface
	{
		Q_OBJECT
  
		public:
			ConnectionDBus(ConnectionSettings::Connection* parent);
			~ConnectionDBus();

		public slots:
			void slotAboutToBeRemoved();
			void slotUpdated();

		protected:
			// implementations of the Setting DBus-interface
			bool GetID(TQString& id, TQT_DBusError& error);
			bool GetSettings(TQT_DBusDataMap<TQString>& settings, TQT_DBusError& error);
			bool Update(const TQT_DBusDataMap<TQString>& properties, TQT_DBusError& error);
			bool Delete(TQT_DBusError& error);

			// used from both interfaces
			void handleMethodReply(const TQT_DBusMessage& reply);
			bool handleSignalSend(const TQT_DBusMessage& reply);
			TQString objectPath() const;

		private:
			ConnectionDBusPrivate* d;
	};
}
#endif /* KNETWORKMANAGER_CONNECTION_DBUS_H */
