

#ifndef REPLAYGAINPLUGINLOADER_H
#define REPLAYGAINPLUGINLOADER_H

#include "pluginloaderbase.h"


/**
 * @short The complete data, how to use the backend
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ReplayGainPlugin
{
public:
    /**
     * Constructor
     */
    ReplayGainPlugin();

    /**
     * Destructor
     */
    virtual ~ReplayGainPlugin();

    TQString filePathName; // the file name of th plugin (needed to detect write permissions)

    struct Info
    {
        int version;    // the version of our plugin (v0.2.1 = 201, v11.3 = 110300)
        TQString name;   // the name of our plugin
        TQString author; // the author of the plugin
        TQString about;  // a short information aboue the plugin
    } info;

    struct ReplayGain
    {
        //PluginLoaderBase::FeatureLevel level;
        int rank;
        TQString bin;
        TQString param;
        TQString silent_param;
        TQStringList mime_types;
        TQString in_files;
        TQString output_single;
        TQString output_multiple;
        TQString force;
        TQString skip;
        TQString track; // TODO remove track and album (put them into param)
        TQString album;
        TQString remove;

        /*struct Test // obsolete
        {
            bool enabled;
            TQString param;
            TQString output_track;
            TQString output_album;
        } test;*/
    } replaygain;
};

/**
 * @short The plugin loader for the replaygain plugins
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ReplayGainPluginLoader : public PluginLoaderBase
{
    Q_OBJECT
  
public:
    /**
     * Constructor
     */
    ReplayGainPluginLoader();

    /**
     * Destructor
     */
    virtual ~ReplayGainPluginLoader();

    /** is this file a replaygain plugin and loadable? */
    int verifyFile( TQString );
    /** load a given file */
    ReplayGainPlugin* loadFile( TQString );
};

#endif // REPLAYGAINPLUGINLOADER_H
