

#ifndef OPTIONSDETAILED_H
#define OPTIONSDETAILED_H

#include "outputdirectory.h"
#include "conversionoptions.h"

#include <tqwidget.h>

class Config;
//class OutputDirectory;
class ConversionOptions;

class TQLabel;
class KIntSpinBox;
class TQCheckBox;
class KComboBox;
class KLineEdit;
class TDEToolBarButton;

/**
 * @short The options widget for setting up the output options more detailed
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class OptionsDetailed : public TQWidget
{
    Q_OBJECT
  
public:
    /**
     * Constructor
     */
    OptionsDetailed( Config*, TQWidget* parent=0, const char* name=0 );

    /**
     * Destructor
     */
    virtual ~OptionsDetailed();

    /**
     * Return the current options
     */
    ConversionOptions getCurrentOptions();

    /**
     * Set the current options
     */
    void setCurrentOptions( const ConversionOptions& );

    /**
     * Refills the whole form (e.g. after a config change)
     */
    void refill(); // TODO syncronize with optionsSimple

private:
    KComboBox* cFormat;
    KComboBox* cQualityMode;
    KIntSpinBox* iQuality;
    KComboBox* cBitrateMode;

    TQCheckBox* cBitrateRangeSwitch;
    KIntSpinBox* iMinBitrate;
    TQLabel* lBitrateRangeTo;
    KIntSpinBox* iMaxBitrate;
    TQLabel* lBitrateRangeUnit;

    TQCheckBox* cSamplingrateSwitch;
    KComboBox* cSamplingrate;
    TQLabel* lSamplingrateUnit;
    TQCheckBox* cChannelsSwitch;
    KComboBox* cChannels;
    TQCheckBox* cReplayGain;

    TDEToolBarButton* pProfileSave;

    KLineEdit* lUserOptions;

    TQWidget* normalOptions;
    TQWidget* advancedOptions;

    OutputDirectory* outputDirectory;

    Config* config;
//     TQString getQualityMode();

    TQString lastQualityMode;

    /** because we can't search within combo boxes, we need a seperate string lists, that we can search */
    TQStringList sFormat;
    TQStringList sQualityMode;
    TQStringList sBitrateMode;
    TQStringList sChannels;
    int formatIndex( const TQString &string );
    int qualityModeIndex( const TQString &string );
    int bitrateModeIndex( const TQString &string );
    int channelsIndex( const TQString &string );

    int getQuality();
    bool getBitrateRangeEnabled();
    bool getSamplingrateEnabled();
    int getSamplingrate();
    bool getChannelsEnabled();
    TQString getChannels();

private slots:
    void formatChanged();
    void qualityModeChanged();
    void qualityChanged();
    void bitrateModeChanged();
    void bitrateRangeToggled();
    void samplingrateToggled();
    void channelsToggled();
    void saveProfile();
    void somethingChanged();

public:
    TQString getFormat();
    OutputDirectory::Mode getOutputDirectoryMode();
    TQString getOutputDirectoryPath();
    void setFormat( const TQString &format );
    void setQualityMode( const TQString &qualityMode );
    void setQuality( int quality );
    void setBitrateMode( const TQString &bitrateMode );
    void setBitrateRangeEnabled( bool enabled );
    void setMinBitrate( int bitrate );
    void setMaxBitrate( int bitrate );
    void setSamplingrateEnabled( bool enabled );
    void setSamplingrate( int sampleRate );
    void setSamplingrate( const TQString &sampleRate );
    void setChannelsEnabled( bool enabled );
    void setChannels( const TQString &channels );
    void setReplayGainEnabled( bool enabled );
    void setOutputDirectoryMode( OutputDirectory::Mode mode );
    void setOutputDirectoryPath( const TQString &path );
    void setUserOptions( const TQString &options );

public slots:
    void toggleAdvancedOptions();

signals:
    void optionsChanged();
};

#endif // OPTIONSDETAILED_H
