#include <stdio.h>
#include <jni.h>
#define TRUE true // prevent qglobal from redefining it
#define FALSE false
#include <dcopclient.h>
#include <kdebug.h>


#include "org_trinitydesktop_DCOP_Client.h"


class client
{
public:
	
  static DCOPClient *instance();

private:

  static DCOPClient *_client;

};


DCOPClient *client::_client = 0;


DCOPClient *client::instance()
{
  if (!_client) 
    _client = new DCOPClient;

  return _client;
}


JNIEXPORT jboolean JNICALL Java_org_trinitydesktop_DCOP_Client_attach(JNIEnv *, jobject)
{
  kdDebug() << "javadcop::attach() called" << endl;

  return client::instance()->attach();
}


JNIEXPORT jstring JNICALL Java_org_trinitydesktop_DCOP_Client_registerAs(JNIEnv *env, jobject, jstring appName)
{
  TQString name(env->GetStringUTFChars(appName, 0));
	  
  kdDebug() << "javadcop::registerAs(\"" << name << "\") called" << endl;  

  TQString rname = client::instance()->registerAs(name.local8Bit(), false); 

  return env->NewStringUTF(rname.local8Bit().data());
}	


JNIEXPORT jboolean JNICALL Java_org_trinitydesktop_DCOP_Client_isAttached(JNIEnv *, jobject)
{
  kdDebug() << "javadcop::isAttached() called" << endl;

  return client::instance()->isAttached();
}


JNIEXPORT jboolean JNICALL Java_org_trinitydesktop_DCOP_Client_detach(JNIEnv *, jobject)
{
  kdDebug() << "javadcop::detach() called" << endl;

  return client::instance()->detach();
}


JNIEXPORT jboolean JNICALL Java_org_trinitydesktop_DCOP_Client_send__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2(JNIEnv *env, jobject, jstring remApp, jstring remObj, jstring remFun, jstring data)
{
  TQString _remApp(env->GetStringUTFChars(remApp, 0));
  TQString _remObj(env->GetStringUTFChars(remObj, 0));
  TQString _remFun(env->GetStringUTFChars(remFun, 0));
  TQString _data(env->GetStringUTFChars(data, 0));

  kdDebug() << "javadcop::send(" << _remApp << "," << _remObj << "," << _remFun << "," << _data << "," <<") called" << endl;

  return client::instance()->send(_remApp.local8Bit(), _remObj.local8Bit(), _remFun.local8Bit(), _data.local8Bit());
}


TQByteArray byteArray(JNIEnv *env, jbyteArray a)
{
  jsize len = env->GetArrayLength(a);
  TQByteArray _data(len);
  jboolean isCopy;
  _data.duplicate((const char *)env->GetByteArrayElements(a, &isCopy), len);

  return _data;
}


JNIEXPORT jboolean JNICALL Java_org_trinitydesktop_DCOP_Client_send__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2_3B(JNIEnv *env, jobject, jstring remApp, jstring remObj, jstring remFun, jbyteArray data)
{
  TQString _remApp(env->GetStringUTFChars(remApp, 0));
  TQString _remObj(env->GetStringUTFChars(remObj, 0));
  TQString _remFun(env->GetStringUTFChars(remFun, 0));
  TQByteArray _data = byteArray(env, data);

  kdDebug() << "javadcop::send(" << _remApp << "," << _remObj << "," << _remFun << ", data[" << _data.size() << "], " <<") called" << endl;
  for (uint i=0; i<_data.size(); ++i)
    kdDebug() << "  data[" << i << "] = " << _data[i] << endl;

  return client::instance()->send(_remApp.local8Bit(), _remObj.local8Bit(), _remFun.local8Bit(), _data);
}


JNIEXPORT jboolean JNICALL Java_org_trinitydesktop_DCOP_Client_isRegistered(JNIEnv *, jobject)
{
  kdDebug() << "javadcop::isRegistered() called" << endl;

  return client::instance()->isRegistered();
}


JNIEXPORT jstring JNICALL Java_org_trinitydesktop_DCOP_Client_appId(JNIEnv *env, jobject)
{
  kdDebug() << "javadcop::appId called" << endl;

  return env->NewStringUTF(client::instance()->appId().data());
}


JNIEXPORT void JNICALL Java_org_trinitydesktop_DCOP_Client_suspend(JNIEnv *, jobject)
{
  kdDebug() << "javadcop::suspend() called" << endl;

  client::instance()->suspend();
}


JNIEXPORT void JNICALL Java_org_trinitydesktop_DCOP_Client_resume(JNIEnv *, jobject)
{
  kdDebug() << "javadcop::resume() called" << endl;

  client::instance()->resume();
}


JNIEXPORT jobject JNICALL Java_org_trinitydesktop_DCOP_Client_call(JNIEnv *env, jobject, jstring remApp, jstring remObj, jstring remFun, jbyteArray data, jboolean eventLoop)
{
  TQString _remApp(env->GetStringUTFChars(remApp, 0));
  TQString _remObj(env->GetStringUTFChars(remObj, 0));
  TQString _remFun(env->GetStringUTFChars(remFun, 0));
  TQByteArray _data = byteArray(env, data);

  kdDebug() << "javadcop::call(" << _remApp << "," << _remObj << "," << _remFun << ", data[" << _data.size() << "], " << eventLoop <<") called" << endl;
  for (uint i=0; i<_data.size(); ++i)
    kdDebug() << "  data[" << i << "] = " << _data[i] << endl;

  TQCString _retType;
  TQByteArray _retData;
  bool retval = client::instance()->call(_remApp.local8Bit(), _remObj.local8Bit(), _remFun.local8Bit(), _data, _retType, _retData, eventLoop);

  kdDebug() << "Return type " << _retType << endl;

  for (uint i=0; i<_retData.size(); ++i)
    kdDebug() << " retData[" << i << "] = " << _retData[i] << endl;

  // create a response object 
  jclass    jcls;
  jmethodID jmid;
  jobject   response;
  jfieldID  jfid;

  jcls = env->FindClass("Lorg/trinitydesktop/DCOP/Response;");
  if (!jcls)
    return NULL;

  jmid = env->GetMethodID(jcls, "<init>", "()V");
  if (!jmid)
    return NULL;
  
  response = env->NewObject(jcls, jmid);
  if (!response)
    return NULL;

  jfid = env->GetFieldID(jcls, "returnType", "Ljava/lang/String;");
  if (!jfid)
    return NULL;
  env->SetObjectField(response, jfid, env->NewStringUTF(_retType.data()));

  jfid = env->GetFieldID(jcls, "returnValue", "Z");
  if (!jfid)
    return NULL;
  env->SetBooleanField(response, jfid, retval);

  jfid = env->GetFieldID(jcls, "returnData", "[B");
  if (!jfid)
    return NULL;
  jbyteArray ba = env->NewByteArray(_retData.size());
  env->SetByteArrayRegion(ba, 0, _retData.size(), (jbyte*) _retData.data());
  env->SetObjectField(response, jfid, ba);

  // return the response object
  kdDebug() << "response object created" << endl;
  return response;
}

JNIEXPORT jboolean JNICALL Java_org_trinitydesktop_DCOP_Client_isApplicationRegistered(JNIEnv *env, jobject, jstring remApp)
{
  const TQCString _remApp(env->GetStringUTFChars(remApp, 0));

  kdDebug() << "javadcop::isApplicationRegistered() called" << endl;

  return client::instance()->isApplicationRegistered(_remApp);
}
