/***************************************************************************
                          timer.cpp - Widget for running scripts periodically
                             -------------------
    copyright            : (C) 2004 Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* QT INCLUDES */
#include <tqstringlist.h>
#include <tqtimer.h>
#include <tqwidget.h>

/* KDE INCLUDES */
#include <tdeglobal.h>
#include <kiconloader.h>
#include <tdelocale.h>


/* OTHER INCLUDES */
#include <myprocess.h>
#include <specials.h>
#include "timer.h"
#include "kommanderplugin.h"
#include "specials.h"


enum Functions {
  FirstFunction = 179,
  SetInterval,
  LastFunction
};

Timer::Timer(TQWidget *a_parent, const char *a_name)
  : TQLabel(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
  if (KommanderWidget::inEditor)
  {
    setPixmap(TDEGlobal::iconLoader()->loadIcon("kalarm", TDEIcon::NoGroup, TDEIcon::SizeMedium));
    setFrameStyle(TQFrame::Box | TQFrame::Plain);
    setLineWidth(1);
    setFixedSize(pixmap()->size());
  }
  else
    setHidden(true);
  
  mTimer = new TQTimer(this);
  setInterval(5000);
  setSingleShot(false);
  connect(mTimer, TQT_SIGNAL(timeout()), TQT_SLOT(timeout()));

  KommanderPlugin::setDefaultGroup(Group::DCOP);
  KommanderPlugin::registerFunction(SetInterval, "setInterval(TQString widget, int interval)",  i18n("Set the timer timeout interval in ms."), 2);
}

Timer::~Timer()
{
}

int Timer::interval() const
{
  return mInterval;
}

void Timer::setInterval(int a_interval)
{
  if (mTimer->isActive())
  {
    mTimer->changeInterval(a_interval);
  }
  mInterval = a_interval;
}
      
bool Timer::singleShot() const
{
  return mSingleShot;
}

void Timer::setSingleShot(bool a_shot)
{
  mSingleShot = a_shot;
}

TQString Timer::currentState() const
{
  return TQString("default");
}

bool Timer::isKommanderWidget() const
{
  return true;
}

TQStringList Timer::associatedText() const
{
  return KommanderWidget::associatedText();
}

void Timer::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void Timer::setWidgetText(const TQString& a_text)
{
  KommanderWidget::setAssociatedText(a_text);
}

void Timer::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString Timer::populationText() const
{
  return KommanderWidget::populationText();
}

void Timer::populate()
{
  setAssociatedText(KommanderWidget::evalAssociatedText(populationText()));
}

void Timer::executeProcess(bool blocking)
{
  MyProcess process(this);
  process.setBlocking(blocking);
  process.run(evalAssociatedText());
  if (blocking)
    emit finished();
}

void Timer::timeout()
{
  executeProcess(true);
}

void Timer::execute()
{
  if (mSingleShot)
    TQTimer::singleShot(mInterval, this, TQT_SLOT(timeout()));
  else
    mTimer->start(mInterval);
}

void Timer::cancel()
{
  mTimer->stop();
}
      
      

bool Timer::isFunctionSupported(int f)
{
  return f == DCOP::setText || f == DCOP::execute || f == DCOP::cancel || (f > FirstFunction && f < LastFunction);
}

TQString Timer::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::setText:
      setAssociatedText(args[0]);
      break;
    case DCOP::execute:
      execute();
      break;
    case DCOP::cancel:
      cancel();
      break;
    case SetInterval:
      setInterval(args[0].toInt());
      break;
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}

#include "timer.moc"
