/***************************************************************************
                          closebutton.h - Button that when clicked, closes the dialog it's in
                          -------------------
    copyright            : (C) 2002-2003 Marc Britton <consume@optusnet.com.au>
                           (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _HAVE_CLOSEBUTTON_H_
#define _HAVE_CLOSEBUTTON_H_

/* KDE INCLUDES */
#include <kpushbutton.h>

/* QT INCLUDES */
#include <tqobject.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <kommander_export.h>
class TQWidget;

class TQShowEvent;
class KOMMANDER_EXPORT CloseButton : public KPushButton, public KommanderWidget
{
  Q_OBJECT
  

  TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget)
  TQ_PROPERTY(bool writeStdout READ writeStdout WRITE setWriteStdout)
public:
  CloseButton(TQWidget* a_parent, const char* a_name);
  ~CloseButton();

  virtual bool isKommanderWidget() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQStringList associatedText() const;
  virtual TQString currentState() const;
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);
  bool writeStdout() const;
  
  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual bool isFunctionSupported(int function);
public slots:
  virtual void setWriteStdout(bool);
  virtual void setWidgetText(const TQString &);
  virtual void startProcess();
  virtual void appendOutput(TDEProcess*, char*, int);
  virtual void endProcess(TDEProcess*);
  virtual void populate();
signals:
  void widgetOpened();
  void widgetTextChanged(const TQString&);
protected:
  bool m_writeStdout;
  TQString m_output;
  void showEvent(TQShowEvent* e);
private:
};

#endif
