/***************************************************************************
 *   Copyright (C) 2001 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *   Copyright (C) 2001 by Sandy Meier                                     *
 *   smeier@kdevelop.org                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _APPWIZARDDIALOG_H_
#define _APPWIZARDDIALOG_H_

class AppWizardPart;
class TQMultiLineEdit;
class TQRadioButton;
class KTempFile;
class TQWidgetStack;
class TQVBox;
class TDEPopupMenu;
class TQHBoxLayout;
class KArchiveDirectory;
class KArchiveFile;
class ProfileSupport;
#include <tqptrlist.h>
#include <tqdict.h>
#include <klineedit.h>
#include <tqlabel.h>
#include <tqstringlist.h>
#include <tdelistview.h>
#include <kiconview.h>
#include "kdevversioncontrol.h"
#include "kdevvcsintegrator.h"
#include "appwizarddlgbase.h"
#include "vcs_form.h"
//#include "autoform.h"
#include "kdevlicense.h"

namespace PropertyLib {
	class PropertyList;
	class PropertyEditor;
}

struct installFile
{
	TQString source;
	TQString dest;
	TQString option;
	bool process;
	bool isXML;
};

struct installArchive
{
	TQString source;
	TQString dest;
	TQString option;
	bool process;
};

struct installDir
{
	TQString dir;
	TQString option;
	int perms;
};

struct ApplicationInfo
{
    TQString templateName;
    TQString name;
    TQString comment;
    TQString icon;
    TQString category;
    TQString defaultDestDir;
    TQString fileTemplates;
    TQStringList openFilesAfterGeneration;
    TQString templateFile;
    TQMap<TQString,TQString> subMap;
	TQMap<TQString,TQString> subMapXML;
    TQStringList includes;

	//TQMap<autoKey,TQVariant> subValues;
	PropertyLib::PropertyList *propValues;

    TQValueList<installFile> fileList;
    TQValueList<installArchive> archList;
    TQValueList<installDir> dirList;
    TQString customUI;
    TQString message;
    TQString finishCmd;
    TQString finishCmdDir;
    TQString sourceArchive;

    //! item pointer to the listview
    TQListViewItem *item;

	//! pointer to favourite icon (NULL if there isn't one)
	TQIconViewItem *favourite;

    ApplicationInfo()
    : item( 0 ), favourite( 0 )
    {}
};

struct AppWizardFileTemplate
{
    TQString suffix;
    TQString style;
    TQMultiLineEdit *edit;

    AppWizardFileTemplate()
    : edit( 0 )
    {}
};


class AppWizardDialog : public AppWizardDialogBase
{
    Q_OBJECT
  

public:
    AppWizardDialog( AppWizardPart *part, TQWidget *parent=0, const char *name=0 );
    ~AppWizardDialog();
    TQString getProjectName() { return appname_edit->text(); }
    TQString getProjectLocation() { return finalLoc_label->text(); }

protected:
    virtual void accept();

	virtual TQDict<KDevLicense> licenses();
	void loadLicenses();

protected slots:
    virtual void templatesTreeViewClicked(TQListViewItem*);
    virtual void textChanged();
    virtual void licenseChanged();
    virtual void destButtonClicked(const TQString&);
    virtual void projectNameChanged();
    virtual void projectLocationChanged();
    virtual void favouritesIconViewClicked( TQIconViewItem * );
	virtual void templatesContextMenu(TQListViewItem*, const TQPoint&, int);
	virtual void favouritesContextMenu(TQIconViewItem* item, const TQPoint& point);
	virtual void addTemplateToFavourites();
	virtual void done(int r);
	virtual void removeFavourite();
	virtual void pageChanged();

private: //methods

    ApplicationInfo *templateForItem(TQListViewItem *item);
    void insertCategoryIntoTreeView(const TQString &completeCategoryPath);
    void loadVcs();
	void updateNextButtons();

	void populateFavourites();
	void addFavourite(TQListViewItem* item, TQString favouriteName="");
	ApplicationInfo* findFavouriteInfo(TQIconViewItem* item);

	void unpackArchive( const KArchiveDirectory *dir, const TQString &dest, bool process );
	bool copyFile( const installFile& file );
	bool copyFile( const TQString &source, const TQString &dest, bool isXML, bool process );
	TQString kdevRoot(const TQString &templateName ) const;
	void openAfterGeneration();

	void setPermissions(const KArchiveFile *source, TQString dest);
	void setPermissions(const installFile &file);

	void checkAndHideItems(TQListView *view);
	bool checkAndHideItems(TQListViewItem *item);

private: //data

    TQPtrList<ApplicationInfo> m_appsInfo;
	TQValueList<AppWizardFileTemplate> m_fileTemplates;
    //! Store the category name and the pointer in the treeview
    TQDict<TQListViewItem> m_categoryMap;
	TQValueList<TQListViewItem*> m_categoryItems;
    //! A list of currently available version control systems
//    TQDict<KDevVersionControl> m_availVcs;

    TQHBoxLayout *m_custom_options_layout;
	PropertyLib::PropertyEditor *m_customOptions;
    AppWizardPart *m_part;
    TQWidget *m_lastPage;
    TQPtrList<KTempFile> m_tempFiles;
    ApplicationInfo* m_pCurrentAppInfo;
    bool m_projectLocationWasChanged;
    VcsForm *m_vcsForm;
    bool m_pathIsValid;
	TDEPopupMenu* m_favouritesMenu;
	TDEPopupMenu* m_templatesMenu;

	TQDict<KDevLicense> m_licenses;
	TQDict<KDevVCSIntegrator> m_integrators;
	TQMap<int, VCSDialog*> m_integratorDialogs;

	ProfileSupport *m_profileSupport;

public slots:
    virtual void showTemplates(bool all);
};

#endif
