/*
 *
 *            kPPP: A pppd front end for the KDE project
 *
 * $Id$
 * 
 *            Copyright (C) 1997 Bernd Johannes Wuebben 
 *                   wuebben@math.cornell.edu
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#ifndef PWENTRY_H
#define PWENTRY_H
 
#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqlabel.h>
#include <tqgroupbox.h>

class PWEntry : public TQWidget {

	Q_OBJECT
  

public:

   PWEntry( TQWidget *parent=0,  const char *name=0 );   
   bool Consumed();
   void setConsumed();
   TQString text();
   void setPrompt(const TQString &);

public slots:

    void setEchoModeNormal();
    void setEchoModePassword();
    void hide();
    void show();

signals:

    void returnPressed();

protected:

    void resizeEvent(TQResizeEvent* qre);
    void focusInEvent( TQFocusEvent *);

private:

    TQGroupBox *frame;
    TQLineEdit *pw;
    TQLabel *pl;
    bool isconsumed;

};
 
#endif
