"""
This template constructs an application with menus, toolbar and statusbar.
It uses KDE classes and methods that simplify the task of building and
operating a GUI. It is recommended that this approach be used, rather
than the primitive approach in menuapp1.py
"""

"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""


False = 0
True  = not False


import sys, os

from python_tqt.qt import TQPopupMenu, SIGNAL, TQLabel, TQIconSet

from tdecore import TDEApplication, TDECmdLineArgs, TDEAboutData, i18n, TDEIcon, TDEIconLoader, TDEShortcut, TDEGlobal
from tdeui import TDEMainWindow, KMessageBox, KStdAction, TDEAction, TDEToggleAction, TDEFontSizeAction, TDEFontAction, TDERadioAction,\
                  TDEActionSeparator, TDEActionMenu, KWindowListMenu, KXMLGUIClient, TDEActionCollection

STATUSBAR_LEFT   = 1
STATUSBAR_MIDDLE = 2
STATUSBAR_RIGHT  = 3

class MainWin (TDEMainWindow):
    def __init__ (self, *args):
        apply (TDEMainWindow.__init__, (self,) + args)

        self.initActions ()
        self.setGeometry (0, 0, 350, 200)

        # The second arg of createGUI needs to be 0 (or False)
        # to enable XMLGUI features like ActionList (in 'dynamicActions')
        # If the default is used (True), the dynamic actions will not
        # appear in the menus
        self.createGUI (os.path.join (mainpath, "xmlmenudemoui.rc"), 0)

        self.dynamicActions()

        # Can't do this until the toolBar has been created in createGUI
        stretchlbl = TQLabel ("", self.toolBar ())
        self.toolBar ().setStretchableWidget (stretchlbl)

        self.initStatusBar ()

        self.saveAction.setEnabled (False)
        self.saveAsAction.setEnabled (False)

    def initActions (self):
        # This is used in all of the TDEAction/KStdAction constructors --
        # Seems more efficient to only do the call once
        acts = self.actionCollection ()

        # This is used often enough, we just define it here
        scNull = TDEShortcut.null ()

        # "File" menu items
        self.newAction      = KStdAction.openNew (self.slotNew, acts)
        self.openAction     = KStdAction.open (self.slotOpen, acts)
        self.saveAction     = KStdAction.save (self.slotSave, acts)
        self.saveAsAction   = KStdAction.saveAs (self.slotSaveAs, acts)
        self.printAction    = KStdAction.print_ (self.slotPrint, acts)
        self.quitAction     = KStdAction.quit (self.slotQuit, acts)

        # "Edit" menu items
        self.undoAction     = KStdAction.undo (self.slotUndo, acts)
        self.redoAction     = KStdAction.redo (self.slotRedo, acts)
        self.cutAction      = KStdAction.cut (self.slotCut, acts)
        self.copyAction     = KStdAction.copy (self.slotCopy, acts)
        self.pasteAction    = KStdAction.paste (self.slotPaste, acts)
        self.findAction     = KStdAction.find (self.slotFind, acts)
        self.findNextAction = KStdAction.findNext (self.slotFindNext, acts)
        self.replaceAction  = KStdAction.replace (self.slotReplace, acts)

        # NOTE!!!! You must specify a parent and name for the action object in its constructor
        # Normally in a constructor like
        #
        #   someObject (TQWidget *parent = 0, const char *name = 0)
        #
        # the parent may or may not be assigned, but widgets usually ignore the
        # name argument. For an action of *any* type (other than KStdAction),
        # the 'name' argument is what is used to load the action into the menus
        # and toolBar (in the line below, "specialActionName"). The XMLGUI mechanism
        # has no way to find out about the action objects except through their
        # object names - the variable the object is assigned to ('self.specialAction')
        # has no meaning in XNLGUI terms except through the objects 'name' member value

        self.specialAction  = TDEAction (i18n ("Special"), scNull, self.slotSpecial, acts, "specialActionName")

        # Demo menu items

        # TDEToggleAction has an isChecked member and emits the "toggle" signal
        self.toggle1Action  = TDEToggleAction ("Toggle 1", scNull, acts, "toggle1Action")
        self.toggle2Action  = TDEToggleAction ("Toggle 2", scNull, self.slotToggle2, acts, "toggle2Action")

        # A separator - create once/use everywhere
        self.separateAction = TDEActionSeparator (acts, "separateAction")

        # Font stuff in menus or toolbar
        self.fontAction     = TDEFontAction ("Font", scNull, acts, "fontAction")
        self.fontSizeAction = TDEFontSizeAction ("Font Size", scNull, acts, "fontSizeAction")

        self.fontAction.setComboWidth (150)
        self.fontSizeAction.setComboWidth (75)

       # Need to assign an icon to actionMenu below
        icons = TDEIconLoader ()
        iconSet = TQIconSet (icons.loadIcon ("viewmag", TDEIcon.Toolbar))

        # Nested menus using TDEActions (also nested on toolbar)
        self.actionMenu     = TDEActionMenu ("Action Menu", acts, "actionMenu")
        self.actionMenu.setIconSet (iconSet)

        # By using KStdAction here, the XMLGUI mechanism will automatically
        # create a 'View' menu and insert "Zoom In" and "Zoom Out" objects
        # in it. This happens because before parsing our *ui.rc file,
        # the standard KDE file config/ui/ui_standards.rc is parsed, and
        # then our *ui.rc file is merged with the result - this gives KDE
        # menus and toolBars a standard "look" and item placement (including
        # separators). Creating the KStdActions alone is sufficient - you
        # could delete their references from the *ui.rc file and the menu
        # items would still be created via ui_standards.rc
        self.actionMenu.insert (KStdAction.zoomIn (self.slotZoomIn, acts))
        self.actionMenu.insert (KStdAction.zoomOut (self.slotZoomOut, acts))

        self.radio1Action = TDERadioAction ("Radio 1", scNull, self.slotRadio, acts, "radio1")
        self.radio1Action.setExclusiveGroup ("Radio")
        self.radio1Action.setChecked (1)
        self.radio2Action = TDERadioAction ("Radio 2", scNull, self.slotRadio, acts, "radio2")
        self.radio2Action.setExclusiveGroup ("Radio")
        self.radio3Action = TDERadioAction ("Radio 3", scNull, self.slotRadio, acts, "radio3")
        self.radio3Action.setExclusiveGroup ("Radio")


    def initStatusBar (self):
        self.statusBar ().insertItem ("", STATUSBAR_LEFT, 1000, True)
        self.statusBar ().insertItem ("", STATUSBAR_MIDDLE, 1000, True)
        self.statusBar ().insertItem ("", STATUSBAR_RIGHT, 1000, True)

    def dynamicActions (self):
        # This creates something like a 'recent files list' in the 'File' menu
        # (There is a TDERecentFilesAction that probably should be used instead,
        # but this demos the use of action lists)
        # The code here corresponds to the <ActionList name="recent"/> entry
        # in the rc file

        # Just fake some filenames for now
        fakeFiles = ["tdeaction.sip", "kxmlguiclient.sip"]

        # Clear the old entries, so we don't end up accumulating entries in the menu
        self.unplugActionList("recent");
        self.dynamicActionsList = []

        # Create a TDEAction for each entry and store the TDEActions in a list
        # Use 'None' for the TDEActionCollection argument in the TDEAction constructor
        # in this case only
        for i in range (len (fakeFiles)):
            act = TDEAction (i18n (" ".join (["&" + str (i), fakeFiles [i]])), TDEShortcut.null (),\
                                 self.slotFake, None, fakeFiles [i][:-4] + "open")
            self.dynamicActionsList.append(act)

        # Update the menu with the most recent TDEActions
        self.plugActionList("recent", self.dynamicActionsList)


#-------------------- slots -----------------------------------------------

    def slotFake (self):
        # sender () should be called before anything else
        # (including "notImpl") so the correct sender
        # value is returned
        sender = self.sender ().name ()
        self.notImpl ("Recent files (%s)" % sender)

    # 'id' is for toolbar button signals - ignored for menu signals
    def slotNew (self, id = -1):
        self.notImpl ("New")

    def slotOpen(self, id = -1):
        self.notImpl ("Open")

    def slotSave (self, id = -1):
        self.notImpl ("Save")

    def slotSaveAs (self):
        self.notImpl ("Save As")

    def slotPrint (self):
        self.notImpl ("Print")

    def slotQuit (self):
        self.notImpl ("Quit")

    def slotUndo (self):
        self.notImpl ("Undo")

    def slotRedo (self):
        self.notImpl ("Redo")

    def slotCut (self, id = -1):
        self.notImpl ("Cut")

    def slotCopy (self, id = -1):
        self.notImpl ("Copy")

    def slotPaste (self, id = -1):
        self.notImpl ("Paste")

    def slotFind (self):
        self.notImpl ("Find")

    def slotFindNext (self):
        self.notImpl ("Find Next")

    def slotReplace (self):
        self.notImpl ("Replace")

    def slotSpecial (self):
        self.notImpl ("Special")

    def slotToggle2 (self):
        self.notImpl ("Toggle")

    def slotZoomIn (self):
        self.notImpl ("Zoom In")

    def slotZoomOut (self):
        self.notImpl ("Zoom Out")

    def slotRadio (self):
        sender = self.sender ().name ()
        self.notImpl ("Radio %s" % sender [-1])

    def notImpl (self, item = "Feature"):
        self.statusBar ().changeItem ("%s not implemented" % item, STATUSBAR_LEFT)
        KMessageBox.error (self, "%s not implemented" % item, "Not Implemented")
        self.statusBar ().changeItem ("", STATUSBAR_LEFT)


#-------------------- main ------------------------------------------------

description = "A basic application template"
version     = "1.0"

# The appName (xmlmenudemo - first argument) is required
# if the program is to automatically locate it *ui.rc file
aboutData   = TDEAboutData ("xmlmenudemo", "xmlmenudemo",\
    version, description, TDEAboutData.License_GPL,\
    "(C) 2003 whoever the author is")

aboutData.addAuthor ("author1", "whatever they did", "email@somedomain")
aboutData.addAuthor ("author2", "they did something else", "another@email.address")

mainpath = os.path.dirname (os.path.abspath (sys.argv[0]))
TDECmdLineArgs.init (sys.argv, aboutData)

TDECmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app = TDEApplication ()
mainWindow = MainWin (None, "main window")
mainWindow.show()
app.exec_loop()
