from python_tqt.qt import TQt, TQFrame, TQHBoxLayout, TQVBoxLayout, TQLabel, SIGNAL
from tdeui import KPassivePopup, KTextEdit, KPushButton
from tdecore import TDEGlobal, TDEIcon

iconName = 'popup'
labelText = 'KPassivePopup'
docParts = ('tdeui', 'KPassivePopup')
helpText = ('Examples of the KPassivePopup widget.')


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.help = KTextEdit(helpText, '', self)
        self.button = KPushButton('Show Passive Popups', self)
        
        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help, 10)
        buttonLayout = TQHBoxLayout(layout, 4)
        buttonLayout.addWidget(self.button, 1)
        buttonLayout.addStretch(10)
        layout.addStretch(10)


        self.connect(self.button, SIGNAL('clicked()'), self.showPopups)


    def showPopups(self):
        ## no support for all of the 3.5 calls
        pop = KPassivePopup.message('Hello, <i>KPassivePopup</i>', self)
        pop.setTimeout(3000)
        pop.show()

        
        pos = pop.pos()
        pos.setY(pos.y() + pop.height() + 10)
        
        ico = TDEGlobal.instance().iconLoader().loadIcon('help', TDEIcon.NoGroup,
                                                       TDEIcon.SizeSmall)
        pop = KPassivePopup.message('<b>Hello</b>', 'With Icons', ico, self)
        pop.setTimeout(3000)
        pop.show()
        pop.move(pos)
