//////////////////////////////////////////////////////////////////////////////
//
//    DISPLAYCOMPARE.H
//
//    Copyright (C) 2001 Richard Groult <rgroult at jalix.org> (from ShowImg project)
//    Copyright (C) 2004 Gilles Caulier <caulier dot gilles at gmail dot com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef __DISPLAYCOMPARE_H__
#define __DISPLAYCOMPARE_H__

// Include files for TQt

#include <tqptrvector.h>
#include <tqdict.h>
#include <tqguardedptr.h>

// Include files for KDE

#include <kdialogbase.h>

// Includes file for libKIPI.

#include <libkipi/interface.h>

// Local includes

#include "kpaboutdata.h"

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQGroupBox;
class TQLabel;
class TQListView;
class TQListViewItem;
class TQPushButton;
class TQPrtList;
class TQFile;

class KSqueezedTextLabel;
class KFileItem;

namespace KIPIFindDupplicateImagesPlugin
{

class  DisplayCompare : public KDialogBase
{
Q_OBJECT
  

public:

   DisplayCompare(TQWidget* parent, KIPI::Interface* interface, const TQDict < TQPtrVector < TQFile > >& cmp);
   ~DisplayCompare();

private slots :

   void slotDisplayRight(TQListViewItem *);
   void slotDisplayLeft(TQListViewItem *);
   void slotHelp();
   void slotDelete( void );
   void slotGotPreview1(const KFileItem* url, const TQPixmap &pixmap);
   void slotGotPreview2(const KFileItem* url, const TQPixmap &pixmap);

private:

   const TQDict < TQPtrVector < TQFile > > m_cmp;

   TQGroupBox*          GroupBox1;
   TQGroupBox*          GroupBox2;

   KSqueezedTextLabel* OriginalNameLabel;
   KSqueezedTextLabel* originalInfoLabel1;
   KSqueezedTextLabel* originalInfoLabel2;
   KSqueezedTextLabel* originalInfoLabel3;
   KSqueezedTextLabel* originalInfoLabel4;
   KSqueezedTextLabel* originalInfoLabel5;

   KSqueezedTextLabel* similarNameLabel;
   KSqueezedTextLabel* similarInfoLabel1;
   KSqueezedTextLabel* similarInfoLabel2;
   KSqueezedTextLabel* similarInfoLabel3;
   KSqueezedTextLabel* similarInfoLabel4;
   KSqueezedTextLabel* similarInfoLabel5;

   TQLabel*             preview1;
   TQLabel*             preview2;

   TQListView*          listName;
   TQListView*          listEq;

   TQPushButton        *m_helpButton;

   KIPI::Interface    *m_interface;

   KIPIPlugins::KPAboutData *m_about;
};

}  // NameSpace KIPIFindDupplicateImagesPlugin

#endif   // __DISPLAYCOMPARE_H__

