/*************************************************************************** 
                          xsldbgentitiesimplimpl.cpp  -  description 
                             ------------------- 
    begin                : Sun Jan20 2002 
    copyright            : (C) 2002 by Keith Isdale 
    email                : k_isdale@tpg.com.au 
 ***************************************************************************/ 
 
/*********************************************************************************** 
 *                                                                         										* 
 *   This program is free software; you can redistribute it and/or modify       * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or         * 
 *   (at your option) any later version.                                   							* 
 *                                                                         										* 
 ************************************************************************************/ 
 
#include <tqlistview.h> 
#include <tqlineedit.h> 
 
#include "xsldbgentitiesimpl.h" 
#include "xsldbgdebugger.h" 
#include "xsldbggloballistitem.h" 
 
 
XsldbgEntitiesImpl::XsldbgEntitiesImpl(XsldbgDebugger *debugger, 
	TQWidget *parent /*=0*/, const char *name /*=0*/) 
		:  XsldbgEntities(parent, name),  XsldbgDialogBase() 
{	 
	this->debugger = debugger; 
	connect(debugger,  
		TQT_SIGNAL(entityItem(TQString /*SystemID*/,   
				  TQString /*PublicID*/)), 
		this,  
		TQT_SLOT(slotProcEntityItem(TQString /*SystemID*/,   
					TQString /*PublicID*/)));	 
		 
	connect( entitiesListView,   
		 TQT_SIGNAL(selectionChanged(TQListViewItem *)), 
		 this, TQT_SLOT(selectionChanged(TQListViewItem*))); 
	show(); 
} 
 
 
XsldbgEntitiesImpl::~XsldbgEntitiesImpl(){ 
} 
 
 
void XsldbgEntitiesImpl::slotProcEntityItem(TQString SystemID,  TQString PublicID) 
{ 
	if (SystemID.isNull()) 
		  entitiesListView->clear(); 
	else{		 
		entitiesListView->insertItem( 
		        new XsldbgGlobalListItem(entitiesListView, 
			       SystemID, -1, PublicID)); 
	} 
 
} 
 
 
void XsldbgEntitiesImpl::selectionChanged(TQListViewItem *item) 
{ 
	XsldbgGlobalListItem *globalItem = dynamic_cast<XsldbgGlobalListItem*>(item); 
	if (globalItem){ 
		debugger->gotoLine(globalItem->getFileName(), 1); 
	} 
} 
 
void XsldbgEntitiesImpl::refresh() 
{ 
	debugger->fakeInput("entities", true) ; 
} 
 
 
 
 

#include "xsldbgentitiesimpl.moc"
