/***************************************************************************
                          classinfoview.cpp  -  description
                             -------------------
    begin                : Tue Jan 11 2005
    copyright            : (C) 2005 by Richard Dale
    email                : Richard_Dale@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqobjectdict.h>
#include <tqobjectlist.h>
#include <tqmetaobject.h>
#include <tqstrlist.h>
#include <tqvariant.h>

#include <tdelocale.h>

#include "classinfoview.h"

ClassInfoView::ClassInfoView(TQWidget *parent, const char *name ) : TDEListView(parent,name)
{
  addColumn( i18n( "Name" ) );
  addColumn( i18n( "Value" ) );

  setRootIsDecorated( true );
  setAllColumnsShowFocus( true );
  setFullWidth( true );
}

ClassInfoView::~ClassInfoView()
{
}

void ClassInfoView::buildList( TQObject *o )
{
  TQMetaObject *mo = o->metaObject();

  for (int index = 0; index < mo->numClassInfo(true); index++) {
    const TQClassInfo * classInfo = mo->classInfo(index, true);
    new TDEListViewItem( this, classInfo->tqt_mo_ci_name, classInfo->tqt_mo_ci_value );
  }
}

void ClassInfoView::setTarget( TQObject *o )
{
  clear();
  buildList( o );
}

#include "classinfoview.moc"
