//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: Roie Kerstein <sf_kersteinroie@bezeqint.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ADDBOOKMARKSPLUGIN_H
#define ADDBOOKMARKSPLUGIN_H

#include "addbookmarksprefssettings.h"
#include <kgenericfactory.h>
#include <kopeteplugin.h>
#include <kbookmarkmanager.h>
#include <tdeio/job.h>
#include <tqcstring.h>
#include <tqmap.h>

/**
@author Roie Kerstein <sf_kersteinroie@bezeqint.net>
*/

class BookmarksPlugin : public Kopete::Plugin
{
Q_OBJECT
  
public:
    BookmarksPlugin(TQObject *parent, const char *name, const TQStringList &args);

private:
    typedef struct S_URLANDNAME{
		KURL url;
		TQString sender;
    } URLandName;
    typedef TQMap<TDEIO::TransferJob*,URLandName> JobsToURLsMap;
    JobsToURLsMap m_map;
    BookmarksPrefsSettings m_settings;
    void addKopeteBookmark( const KURL& url, const TQString& sender );
    KURL::List* extractURLsFromString( const TQString& text );
    KBookmarkGroup getKopeteFolder();
    KBookmarkGroup getFolder( KBookmarkGroup group, const TQString& folder );
    TQTextCodec* getPageEncoding( const TQByteArray& data );
public slots:
    void slotBookmarkURLsInMessage(Kopete::Message & msg);
    void slotReloadSettings();

private slots:
    void slotAddKopeteBookmark( TDEIO::Job *transfer, const TQByteArray &data );
};

typedef KGenericFactory<BookmarksPlugin> BookmarksPluginFactory;

#endif
