#ifndef KRICHTEXTEDITPART_H
#define KRICHTEXTEDITPART_H

#include <tdeparts/part.h>

#include <tqfont.h>
#include <tqcolor.h>

class TDEAboutData;
class KTextEdit;
class TDEFontAction;
class TDEFontSizeAction;
class TDEToggleAction;
class KopeteTextEdit;

/**
 * KParts wrapper for TQTextEdit.
 *
 * Originally by Richard Moore, rich@kde.org
 * forked by Jason Keirstead
 */
class KopeteRichTextEditPart : public KParts::ReadOnlyPart
{
	Q_OBJECT
  

	public:
		KopeteRichTextEditPart( TQWidget *wparent, const char *wname, TQObject*, const char*, const TQStringList& );
		KopeteRichTextEditPart( TQWidget *wparent, const char *wname, int capabilities );

		/**
		* Returns the current editor widget.
		*/
		KTextEdit *widget() const { return (KTextEdit*)editor; }

		TQString text( TQt::TextFormat = TQt::AutoText ) const;

		TQFont font() { return mFont; }

		TQColor fgColor();

		TQColor bgColor();

		void clear();

		int capabilities() { return m_capabilities; }

		bool richTextEnabled() { return m_richTextAvailable && m_richTextEnabled; }

		bool buttonsEnabled() { return !m_richTextAvailable || m_richTextEnabled; }

		static TDEAboutData *createAboutData();

		virtual bool openFile() { return false; };

	public slots:

		void setFgColor();
		void setFgColor( const TQColor & );

		void setBgColor();
		void setBgColor( const TQColor & );

		void setFont();
		void setFont( const TQFont & );
		void setFont( const TQString & );

		void setFontSize( int );

		void setUnderline( bool );
		void setBold( bool );
		void setItalic( bool );

		void setAlignLeft( bool yes );
		void setAlignRight( bool yes );
		void setAlignCenter( bool yes );
		void setAlignJustify( bool yes );

		void checkToolbarEnabled();
		void reloadConfig();
		void slotSetRichTextEnabled( bool enable );

	signals:
		void toggleToolbar( bool enabled );

	protected:
		/**
		* Creates the part's actions in the specified action collection.
		*/
		virtual void createActions( TDEActionCollection *ac );

	protected slots:

		/**
		* Creates the part's actions in the part's action collection.
		*/
		void createActions();
		void updateActions();

		void updateFont();
		void updateCharFmt();
		void updateAligment();

	private:
		void readConfig();
		void writeConfig();

		KopeteTextEdit *editor;
		TDEAction *checkSpelling;
		TDEToggleAction *enableRichText;

		TDEAction *actionFgColor;
		TDEAction *actionBgColor;

		TDEToggleAction *action_bold;
		TDEToggleAction *action_italic;
		TDEToggleAction *action_underline;

		TDEFontAction *action_font;
		TDEFontSizeAction *action_font_size;

		TDEToggleAction *action_align_left;
		TDEToggleAction *action_align_right;
		TDEToggleAction *action_align_center;
		TDEToggleAction *action_align_justify;

		int m_capabilities;
		bool m_richTextAvailable;
		bool m_richTextEnabled;

		bool m_configWriteLock;

		TQFont mFont;
		TQColor mBgColor;
		TQColor mFgColor;
};

#endif // KRICHTEXTEDITPART_H
