/***************************************************************************
    begin                : Thu Sep 12 2002
    copyright            : (C) 2002 - 2004 by Scott Wheeler
    email                : wheeler@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLAYLISTBOX_H
#define PLAYLISTBOX_H

#include "playlistcollection.h"

#include <tdelistview.h>

#include <tqptrdict.h>

class Playlist;
class PlaylistItem;
class ViewMode;
class PlaylistSearch;
class SearchPlaylist;

class TDEPopupMenu;
class TDESelectAction;

typedef TQValueList<Playlist *> PlaylistList;

/** 
 * This is the play list selection box that is by default on the right side of
 * JuK's main widget (PlaylistSplitter). 
 */

class PlaylistBox : public TDEListView, public PlaylistCollection
{
    Q_OBJECT
  

public: 
    class Item;
    typedef TQValueList<Item *> ItemList;

    friend class Item;

    PlaylistBox(TQWidget *parent, TQWidgetStack *playlistStack,
		const char *name = 0);

    virtual ~PlaylistBox();

    virtual void raise(Playlist *playlist);
    virtual void duplicate();
    virtual void remove();

    /**
     * For view modes that have dynamic playlists, this freezes them from
     * removing playlists.
     */
    virtual void setDynamicListsFrozen(bool frozen);

    Item *dropItem() const { return m_dropItem; }

    void setupPlaylist(Playlist *playlist, const TQString &iconName, Item *parentItem = 0);

public slots:
    void paste();
    void clear() {}

    void slotFreezePlaylists();
    void slotUnfreezePlaylists();

protected:
    virtual void setupPlaylist(Playlist *playlist, const TQString &iconName);
    virtual void removePlaylist(Playlist *playlist);

signals:
    void signalPlaylistDestroyed(Playlist *);

private:
    void readConfig();
    void saveConfig();

    virtual void decode(TQMimeSource *s, Item *item);
    virtual void contentsDropEvent(TQDropEvent *e);
    virtual void contentsDragMoveEvent(TQDragMoveEvent *e);
    virtual void contentsDragLeaveEvent(TQDragLeaveEvent *e);
    virtual void contentsMousePressEvent(TQMouseEvent *e);
    virtual void contentsMouseReleaseEvent(TQMouseEvent *e);
    virtual void keyPressEvent(TQKeyEvent *e);
    virtual void keyReleaseEvent(TQKeyEvent *e);

    TQValueList<Item *> selectedItems() const;
    void setSingleItem(TQListViewItem *item);

    void setupItem(Item *item);
    void setupUpcomingPlaylist();
    int viewModeIndex() const { return m_viewModeIndex; }
    ViewMode *viewMode() const { return m_viewModes[m_viewModeIndex]; }

private slots:
    /** 
     * Catches TQListBox::currentChanged(TQListBoxItem *), does a cast and then re-emits
     * the signal as currentChanged(Item *). 
     */
    void slotPlaylistChanged();
    void slotDoubleClicked();
    void slotShowContextMenu(TQListViewItem *, const TQPoint &point, int);
    void slotSetViewMode(int index);
    void slotSavePlaylists();
    void slotShowDropTarget();

    void slotPlaylistItemsDropped(Playlist *p);

    void slotAddItem(const TQString &tag, unsigned column);
    void slotRemoveItem(const TQString &tag, unsigned column);

private:
    TDEPopupMenu *m_contextMenu;
    TQPtrDict<Item> m_playlistDict;
    int m_viewModeIndex;
    TQValueList<ViewMode *> m_viewModes;
    TDEAction *m_k3bAction;
    bool m_hasSelection;
    bool m_doingMultiSelect;
    Item *m_dropItem;
    TQTimer *m_showTimer;
};



class PlaylistBox::Item : public TQObject, public TDEListViewItem
{
    friend class PlaylistBox;
    friend class ViewMode;
    friend class CompactViewMode;
    friend class TreeViewMode;

    Q_OBJECT
  

    // moc won't let me create private TQObject subclasses and TQt won't let me
    // make the destructor protected, so here's the closest hack that will
    // compile.

public:
    virtual ~Item();
    
protected:
    Item(PlaylistBox *listBox, const TQString &icon, const TQString &text, Playlist *l = 0);
    Item(Item *parent, const TQString &icon, const TQString &text, Playlist *l = 0);

    Playlist *playlist() const { return m_playlist; }
    PlaylistBox *listView() const { return static_cast<PlaylistBox *>(TDEListViewItem::listView()); }
    TQString iconName() const { return m_iconName; }
    TQString text() const { return m_text; }
    void setSortedFirst(bool first = true) { m_sortedFirst = first; }

    virtual int compare(TQListViewItem *i, int col, bool) const;
    virtual void paintCell(TQPainter *p, const TQColorGroup &colorGroup, int column, int width, int align);
    virtual void paintFocus(TQPainter *, const TQColorGroup &, const TQRect &) {}
    virtual void setText(int column, const TQString &text);

    virtual TQString text(int column) const { return TDEListViewItem::text(column); }

    virtual void setup();

    static Item *collectionItem() { return m_collectionItem; }
    static void setCollectionItem(Item *item) { m_collectionItem = item; }


protected slots:
    void slotSetName(const TQString &name);

private:
    // setup() was already taken.
    void init();

    Playlist *m_playlist;
    TQString m_text;
    TQString m_iconName;
    bool m_sortedFirst;
    static Item *m_collectionItem;
};

#endif
