import org.trinitydesktop.qt.*;

public class LCDRange extends TQVBox {
	private TQSlider slider;
	
	public LCDRange(TQWidget parent, String name) {
		super(parent, name);
		TQLCDNumber lcd = new TQLCDNumber(2, this, "lcd");
		slider = new TQSlider(Horizontal, this, "slider");
		slider.setRange(0, 99);
		slider.setValue(0);
		
		connect(slider, SIGNAL("valueChanged(int)"),
						lcd, SLOT("display(int)"));
		connect(slider, SIGNAL("valueChanged(int)"),
						SIGNAL("valueChanged(int)"));
	}
	public LCDRange(TQWidget parent) {
		this(parent, null);
	}

	public int value() {
		return slider.value();
	}

	public void setValue(int value) {
		slider.setValue(value);
	}
}
