/***************************************************************************
 *   Copyright (C) 2006 by Sascha Hlusiak                                  *
 *   Spam84@gmx.de                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#ifndef CRYSTALCONFIG_H
#define CRYSTALCONFIG_H

#include <tqobject.h>

#define TOP_LEFT 1
#define TOP_RIGHT 2
#define BOT_LEFT 4
#define BOT_RIGHT 8

class TDEConfig;
class ConfigDialog;

class CrystalConfig : public TQObject
{
	Q_OBJECT
  
public:
	CrystalConfig(TDEConfig* config, TQWidget* parent);
	~CrystalConfig();
    
signals:
	void changed();

public slots:
	void load(TDEConfig*);
	void save(TDEConfig*);
	void defaults();
	void infoDialog();

protected slots:
	void selectionChanged(int);
	void overlay_active_changed(int);
	void overlay_inactive_changed(int);
	void boolChanged(bool) { selectionChanged(0); }
	void colorChanged(const TQColor&) { selectionChanged(0); }
	void textChanged(const TQString&) { selectionChanged(0); }
	void logoTextChanged(const TQString&);

private:
	TDEConfig *config_;
	ConfigDialog *dialog_;

	void updateLogo();
};

#endif // CRYSTALCONFIG_H
