#include <tqcursor.h>
#include <kpixmapeffect.h>
#include <X11/keysym.h>
#include <X11/extensions/XTest.h>
#include <fixx11h.h>

bool LiquidStyle::objectEventHandler( const TQStyleControlElementData &ceData,
                                      ControlElementFlags elementFlags,
                                      void* source,
                                      TQEvent *ev )
{
   if (TDEStyle::objectEventHandler(ceData, elementFlags, source, ev)) {
        return true;
   }

   if (!ceData.widgetObjectTypes.contains(TQOBJECT_OBJECT_NAME_STRING)) {
        return false;
   }
   TQObject* obj = reinterpret_cast<TQObject*>(source);

//   tqWarning("%s, %s <- %s, %s: %d", obj->className(), obj->name(), obj->parent() ? obj->parent()->className() : "none", obj->parent()?obj->parent()->name():"none",ev->type());
   switch (ev->type())
   {
      case TQEvent::None:
      case TQEvent::Timer:
      {
         // first check if this is one of our fading pushbuttons - return elsewise
         if (!(optionHandler->AnimateButton() && ::tqt_cast<TQPushButton*>(obj)))
            return false;
         ButtonFadeInfo *bfi_ = bfi[((TQPushButton*)obj)->winId()];
         if (!bfi_ || ((TQTimerEvent*)ev)->timerId() != bfi_->timerId)
            return false;
         // ok, this is one of our fading buttons asking for repaint
         ((TQPushButton*)obj)->repaint(false);
         int index = bfi_->fadeIn?bfi_->index + 1:bfi_->index - 1;
         // handle border cases
         if (index < 0) // fade-out run has finished, either stop fading stuff, or start fade-in
         {
            bfi_->fadeIn=true;
            if (((TQPushButton*)obj)->isDefault())
            {
               bfi_->index=0;
            }
            else
            {
               obj->killTimer(bfi_->timerId);
               // tqWarning("%u: stopped (%d)", ((TQPushButton*)obj)->winId(), bfi_->timerId);
               bfi_->timerId=0;
               ((TQPushButton*)obj)->repaint(false); // must be to clean out button
            }
         }
         else if (index > 9) // fade-in run has finished, either stop fading stuff, or start fade-out
         {
            if (((TQPushButton*)obj)->isDefault())
            {
               bfi_->fadeIn=false;
               bfi_->index=9;
            }
            else
            {
               obj->killTimer(bfi_->timerId);
               // tqWarning("%u: stopped (%d)", ((TQPushButton*)obj)->winId(), bfi_->timerId);
               bfi_->timerId=0;
            }
         }
         else
            bfi_->index = index;
      }
      case TQEvent::MouseMove:
         if (::tqt_cast<TQTabBar*>(obj))
         {
            TQTabBar *tb = (TQTabBar*)obj;
            TQRect tmpRect;
            bool done = false;
            TQMouseEvent *me = ( TQMouseEvent*)ev;
            int oldTab = hoveredTabIndex;
            if (hoveredTabIndex == -1)
            {
               for (int i = 0; i < tb->count(); i++)
               {
                  if (tb->tabAt(i))
                  {
                     tmpRect = tb->tabAt(i)->rect();
                     if ( tmpRect.x() < me->x() && me->x() < tmpRect.right())
                     {
                        hoveredTabIndex = i;
                        break;
                     }
                  }
               }
            }
            else
            {
               if ((oldTab > 0) && tb->tabAt(oldTab-1))
               {
                  tmpRect = tb->tabAt(oldTab-1)->rect();
                  if ((tmpRect.x() < me->x()) && (me->x() < tmpRect.right()))
                  {
                     hoveredTabIndex = oldTab-1;
                     done = true;
                  }
               }
               if (!done && (oldTab < tb->count()-1) && tb->tabAt(oldTab+1))
               {
                  tmpRect = tb->tabAt(oldTab+1)->rect();
                  if ((tmpRect.x() < me->x()) && (me->x() < tmpRect.right()))
                  {
                     hoveredTabIndex = oldTab+1;
                  }
               }
            }
            if ( oldTab != hoveredTabIndex )
            {
               // reset old tab
               if ( oldTab != -1 )
                  if (tb->tabAt(oldTab)) tb->repaint( tb->tabAt(oldTab)->rect(), false );
               if ( hoveredTabIndex != -1 )
                  tb->repaint( tmpRect, false );
            }
            return false;
         }
         else if ( ::tqt_cast<TQHeader*>(obj) )
         {
            TQHeader *hw = (TQHeader*)obj;
            TQMouseEvent * me = ( TQMouseEvent * ) ev;
            int oldHeader = headerHoverID;
            headerHoverID = hw->orientation() == TQt::Horizontal ? hw->sectionAt( me->x() + hw->offset() ) : hw->sectionAt( me->y() + hw->offset() );
            if ( oldHeader != headerHoverID )
            {
               // reset old header
               if ( oldHeader != -1 )
                  hw->repaint(hw->sectionRect ( oldHeader ), false);
//                   hw->repaint( hw->sectionPos( oldHeader )-hw->offset(), 0, hw->sectionSize( oldHeader ), hw->height(), false );
               if ( headerHoverID != -1 )
                  hw->repaint(hw->sectionRect ( headerHoverID ), false);
//                   hw->repaint( hw->sectionPos( headerHoverID )-hw->offset(), 0, hw->sectionSize( headerHoverID ), hw->height(), false );
            }
            return false;
         }
         return false;
      case TQEvent::Paint:
         if ( ::tqt_cast<TQToolButton*>(obj) )
         {
            TQToolButton * btn = ( TQToolButton * ) obj;
            if (!obj->inherits( "TaskContainer" ))
            {
               if (btn->backgroundOrigin() != TQWidget::WindowOrigin)
                  btn->setBackgroundOrigin( TQWidget::WindowOrigin );
            }
            else
            {
               isTaskContainer = true;
               if ( currentTaskContainer == btn )
                  taskContainerHover = true;
               else
                  taskContainerHover = false;
            }
            return false;
         }
         else if (::tqt_cast<TQMenuBar*>(obj))
         {
            TQWidget *w = (TQWidget *)obj;
            if(w->backgroundMode() != TQt::PaletteBackground)
            {
               w->setBackgroundMode(PaletteBackground);
               w->setBackgroundOrigin(TQWidget::WindowOrigin);
            }
            return false;
         }
         else if ( ::tqt_cast<TQHeader*>(obj) )
         {
            TQHeader *hw = (TQHeader*)obj;
            if (hw->parentWidget() && ::tqt_cast<TQListView*>(hw->parentWidget()))
               headerSortID = ((TQListView*)hw->parentWidget())->sortColumn();
            return false;
         }
         else if ( obj->inherits( "TQDockWindow" ) )
         {
            if (TDEStyle::eventFilter( obj, ev ))
               return true;
            TQWidget * w = ( TQWidget * ) obj;
            if ( w->backgroundMode() != TQt::PaletteBackground )
            {
               w->setBackgroundMode( TQt::PaletteBackground );
               w->setBackgroundOrigin( TQWidget::WindowOrigin );
            }
            return false;
         }
         else if ( obj->inherits( "TQRadioButton" ) || obj->inherits( "TQCheckBox" ) )
         {
            TQButton * btn = ( TQButton * ) obj;
            bool isStatusChild = btn->parent() && ( btn->parent() ->inherits( "TQStatusBar" ) || btn->parent() ->inherits( "KonqFrameStatusBar" ) );
            bool isRadio = obj->inherits( "TQRadioButton" );
            btn->erase();
            TQPainter p;
            p.begin( btn );
            TQFontMetrics fm = btn->fontMetrics();
            TQSize lsz = fm.size( ShowPrefix, btn->text() );
            TQSize sz = isRadio ?
            TQSize( pixelMetric( PM_ExclusiveIndicatorWidth, ceData, elementFlags ), pixelMetric( PM_ExclusiveIndicatorHeight, ceData, elementFlags ) ) :
            TQSize( pixelMetric( PM_IndicatorWidth, ceData, elementFlags ), pixelMetric( PM_IndicatorHeight, ceData, elementFlags ) );
            int x = 0;
            int y = isStatusChild ? 0 : ( btn->height() - lsz.height() + fm.height() - sz.height() ) / 2;
            SFlags flags = Style_Default;
            if ( btn->isEnabled() )
               flags |= Style_Enabled;
            if ( btn->hasFocus() )
               flags |= Style_HasFocus;
            if ( btn->isDown() )
               flags |= Style_Down;
            if ( highlightWidget == btn )
               flags |= Style_MouseOver;
            if ( btn->state() == TQButton::On )
               flags |= Style_On;
            else if ( btn->state() == TQButton::Off )
               flags |= Style_Off;
            if ( isRadio )
               drawControl( CE_RadioButton, &p, ceData, elementFlags, TQRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags, TQStyleOption::Default, btn );
            else
               drawControl( CE_CheckBox, &p, ceData, elementFlags, TQRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags, TQStyleOption::Default, btn );
            x = sz.width() + 6;
            y = 0;
            if ( btn->hasFocus() )
            {
               TQColor tmp( btn->colorGroup().background().dark( 130 ) );
               drawItem( &p, TQRect( sz.width() + 6 + 2, 1, btn->width() - ( sz.width() + 6 + 1 ), btn->height() ), AlignLeft | AlignVCenter | ShowPrefix, btn->colorGroup(), btn->isEnabled(), btn->pixmap(), btn->text(), -1, &tmp );
               drawItem( &p, TQRect( sz.width() + 6 + 3, 2, btn->width() - ( sz.width() + 6 + 1 ), btn->height() ), AlignLeft | AlignVCenter | ShowPrefix, btn->colorGroup(), btn->isEnabled(), btn->pixmap(), btn->text(), -1, &tmp );
            }
            drawItem( &p, TQRect( sz.width() + 6 + 1, 0, btn->width() - ( sz.width() + 6 + 1 ), btn->height() ), AlignLeft | AlignVCenter | ShowPrefix, btn->colorGroup(), btn->isEnabled(), btn->pixmap(), btn->text() );
            p.end();
            return true;
         }
         else if (obj->inherits("KColorGrid") && !(((TQWidget*)obj)->width() && ((TQWidget*)obj)->height()))
            return true;
         return false;
      case TQEvent::KeyPress:
      case TQEvent::KeyRelease:
         return false;
      case TQEvent::Wheel:
         if ( ::tqt_cast<TQScrollView*>(obj) )
         {
            optionHandler->setScrollerActive();
            return false;
         }
         return false;
      case TQEvent::Enter:
         if ( ::tqt_cast<TQToolButton*>(obj) )
         {
            bool isTask = obj->inherits( "TaskContainer" );
            TQToolButton * btn = ( TQToolButton * ) obj;
            if (isTask)
            {
               currentTaskContainer = btn;
               btn->repaint( false );
               return false;
            }
            else if ( btn->isEnabled() )
            {
               highlightWidget = btn;
               btn->repaint( false );
               return false;
            }
         }
         else if ( ::tqt_cast<TQPushButton*>(obj) || ::tqt_cast<TQComboBox*>(obj) || obj->inherits( "TQSplitterHandle" ) || obj->inherits( "AppletHandleDrag" ) )
         {
            TQWidget * btn = ( TQWidget * ) obj;
            if ( btn->isEnabled() )
            {
               highlightWidget = btn;
               btn->repaint( false );
               if (optionHandler->AnimateButton() && ::tqt_cast<TQPushButton*>(obj))
                  fadeIn((TQPushButton*)obj);
            }
            return false;
         }
         else if (::tqt_cast<TDEToolBar*>(obj))
         {
            TQObjectList *handlerList = obj->queryList( "TQDockWindowHandle" );
            for (uint i= 0; i < handlerList->count(); i++)
               ((TQWidget*)(handlerList->at(i)))->repaint(false);
            return false;
         }
         if ( ::tqt_cast<TQScrollBar*>(obj) )
         {
            TQScrollBar * sb = ( TQScrollBar * ) obj;
            if ( !sb->draggingSlider() )
            {
               if ( sb->isEnabled() )
               {
                  activeScroller = sb;
                  highlightWidget = sb;
                  sb->repaint( false );
               }
            }
            return false;
         }
         else if ( ::tqt_cast<TQScrollView*>(obj) )
         {
            TQScrollView *sv = ( TQScrollView * ) obj;
            if (sv->vScrollBarMode() == TQScrollView::AlwaysOff && sv->hScrollBarMode() == TQScrollView::AlwaysOff)
               return false;
            optionHandler->setScrollerActive();
            if (!(highlightWidget == sv->verticalScrollBar()))
               sv->verticalScrollBar()->repaint(false);
            if (!(highlightWidget == sv->horizontalScrollBar()))
               sv->horizontalScrollBar()->repaint(false);
            return false;
         }
         else if ( ::tqt_cast<TQHeader*>(obj) )
         {
            currentHeader = (TQHeader*)obj;
            headerHoverID = -1;
            return false;
         }
         else if (::tqt_cast<TQTabBar*>(obj))
         {
            currentTabBar = (TQTabBar*)obj;
            hoveredTabIndex = -1;
            return false;
         }
         else if ( obj->inherits( "KateView" ) || obj->inherits( "TEWidget") || obj->inherits("CHexViewWidget"))
         {
            TQObjectList *scrollerList = obj->queryList( "TQScrollBar" );
            optionHandler->setScrollerActive();
            for (uint i= 0; i < scrollerList->count(); i++)
               ((TQWidget*)(scrollerList->at(i)))->repaint(false);
            return false;
         }
         else if (obj->inherits("KDockWidgetAbstractHeaderDrag"))
         {
            ((TQWidget *)obj)->repaint();
            return false;
         }
         else if (obj->inherits( "KAnimWidget" ))
         {
            return true;
         }
         else if ( obj->inherits( "TQLineEdit" ) && obj->parent() && ::tqt_cast<TQComboBox*>(obj->parent()))
         {
            TQWidget * btn = ( TQWidget * ) obj->parent();
            if ( btn->isEnabled() )
            {
               highlightWidget = btn;
               btn->repaint( false );
            }
            return false;
         }
         else if ( obj->inherits( "TQRadioButton" ) || obj->inherits( "TQCheckBox" ) )
         {
            TQButton * btn = ( TQButton * ) obj;
            if (btn->isEnabled())
            {
               bool isStatusChild = btn->parent() && ( btn->parent() ->inherits( "TQStatusBar" ) || btn->parent() ->inherits( "KonqFrameStatusBar" ) );
               bool isRadio = obj->inherits( "TQRadioButton" );
               highlightWidget = btn;
               TQFontMetrics fm = btn->fontMetrics();
               TQSize lsz = fm.size( ShowPrefix, btn->text() );
               TQSize sz = isRadio ?
                           TQSize( pixelMetric( PM_ExclusiveIndicatorWidth, ceData, elementFlags ), pixelMetric( PM_ExclusiveIndicatorHeight, ceData, elementFlags ) ) :
                           TQSize( pixelMetric( PM_IndicatorWidth, ceData, elementFlags ), pixelMetric( PM_IndicatorHeight, ceData, elementFlags ) );
               int x = 0;
               int y = isStatusChild ? 0 : ( btn->height() - lsz.height() + fm.height() - sz.height() ) / 2;
               TQPainter p;
               p.begin( btn );
               SFlags flags = Style_Default;
               if ( btn->isEnabled() )
                  flags |= Style_Enabled;
               if ( btn->hasFocus() )
                  flags |= Style_HasFocus;
               if ( btn->isDown() )
                  flags |= Style_Down;
               if ( highlightWidget == btn )
                  flags |= Style_MouseOver;
               if ( btn->state() == TQButton::On )
                  flags |= Style_On;
               else if ( btn->state() == TQButton::Off )
                  flags |= Style_Off;
               if ( isRadio )
                  drawControl( CE_RadioButton, &p, ceData, elementFlags, TQRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags, TQStyleOption::Default, btn );
               else
                  drawControl( CE_CheckBox, &p, ceData, elementFlags, TQRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags, TQStyleOption::Default, btn );
               p.end();
            }
            return false;
         }
         return false;
      case TQEvent::Leave:
         if ( ::tqt_cast<TQToolButton*>(obj) )
         {
            TQToolButton * btn = ( TQToolButton * ) obj;
            if (obj->inherits( "TaskContainer" ))
            {
               currentTaskContainer = NULL;
               btn->repaint( false );
               return false;
            }
            else if ( btn == highlightWidget )
            {
               highlightWidget = NULL;
               btn->repaint( false );
               return false;
            }
         }
         else if ( ::tqt_cast<TQPushButton*>(obj) || ::tqt_cast<TQComboBox*>(obj) || obj->inherits( "TQSplitterHandle" ) || obj->inherits( "AppletHandleDrag" ) )
         {
            TQWidget * btn = ( TQWidget * ) obj;
            if ( btn == highlightWidget )
            {
               highlightWidget = NULL;
               if (optionHandler->AnimateButton() && ::tqt_cast<TQPushButton*>(obj))
                  fadeOut((TQPushButton*)obj);
               else
                  btn->repaint( false );
            }
            return false;
         }
         else if (::tqt_cast<TDEToolBar*>(obj))
         {
            TQObjectList *handlerList = obj->queryList( "TQDockWindowHandle" );
            for (uint i= 0; i < handlerList->count(); i++)
               ((TQWidget*)(handlerList->at(i)))->repaint(false);
            return false;
         }
         if ( ::tqt_cast<TQScrollBar*>(obj) )
         {
            TQScrollBar * sb = ( TQScrollBar * ) obj;
            if ( sb == highlightWidget && !sb->draggingSlider() )
            {
               activeScroller = NULL;
               highlightWidget = NULL;
               sb->repaint( false );
            }
            return false;
         }
         else if ( ::tqt_cast<TQScrollView*>(obj) )
         {
            TQScrollView *sv = (TQScrollView*)obj;
//            if (sv->clipRegion().boundingRect().contains(sv->mapFromGlobal(TQCursor::pos())))
//               return false; // mouse is still in the scrollview
            if (sv->vScrollBarMode() == TQScrollView::AlwaysOff && sv->hScrollBarMode() == TQScrollView::AlwaysOff)
               return false; // no sliders available - don't mess up things
            optionHandler->setScrollerInactive();
            if (!(highlightWidget == sv->verticalScrollBar()))
               sv->verticalScrollBar()->repaint(false);
            if (!(highlightWidget == sv->horizontalScrollBar()))
               sv->horizontalScrollBar()->repaint(false);
            return false;
         }
         else if ( ::tqt_cast<TQHeader*>(obj) )
         {
            TQHeader *hw = (TQHeader*)obj;
            currentHeader = NULL;
            if ( headerHoverID != -1 )
               hw->repaint( hw->sectionPos( headerHoverID )-hw->offset(), 0, hw->sectionSize( headerHoverID ), hw->height(), false );
            headerHoverID = -1;
            return false;
         }
         else if (::tqt_cast<TQTabBar*>(obj))
         {
            TQTabBar *tb = (TQTabBar*)obj;
            currentTabBar = NULL;
            if ( hoveredTabIndex != -1 )
            {
               TQTab *tmpTab = tb->tabAt(hoveredTabIndex);
               if (tmpTab) tb->repaint( tmpTab->rect(), false );
            }
            hoveredTabIndex = -1;
            return false;
         }
         else if ( obj->inherits( "KateView" ) || obj->inherits( "TEWidget") || obj->inherits("CHexViewWidget"))
         {
            TQObjectList *scrollerList = obj->queryList( "TQScrollBar" );
            optionHandler->setScrollerInactive();
            for (uint i= 0; i < scrollerList->count(); i++)
               ((TQWidget*)(scrollerList->at(i)))->repaint(false);
            return false;
         }
         else if (obj->inherits("KDockWidgetAbstractHeaderDrag"))
         {
            ((TQWidget *)obj)->repaint();
            return false;
         }
         else if (obj->inherits( "KAnimWidget" )){
               return true;
         }
         else if ( obj->inherits( "TQLineEdit" ) && obj->parent() && ::tqt_cast<TQComboBox*>(obj->parent())) {
               TQWidget *btn = (TQWidget*)obj->parent();
               if ( btn == highlightWidget )
                  highlightWidget = NULL;
               btn->repaint( false );
               return false;
         }
         else if ( obj->inherits( "TQRadioButton" ) || obj->inherits( "TQCheckBox" ) )
         {
            TQButton * btn = ( TQButton * ) obj;
            if (btn == highlightWidget)
            {
               bool isRadio = obj->inherits( "TQRadioButton" );
               bool isStatusChild = btn->parent() && ( btn->parent() ->inherits( "TQStatusBar" ) || btn->parent() ->inherits( "KonqFrameStatusBar" ) );
               highlightWidget = NULL;
               TQFontMetrics fm = btn->fontMetrics();
               TQSize lsz = fm.size( ShowPrefix, btn->text() );
               TQSize sz = isRadio ?
                           TQSize( pixelMetric( PM_ExclusiveIndicatorWidth, ceData, elementFlags ), pixelMetric( PM_ExclusiveIndicatorHeight, ceData, elementFlags ) ) :
                           TQSize( pixelMetric( PM_IndicatorWidth, ceData, elementFlags ), pixelMetric( PM_IndicatorHeight, ceData, elementFlags ) );
               int x = 0;
               int y = isStatusChild ? 0 : ( btn->height() - lsz.height() + fm.height() - sz.height() ) / 2;
               TQPainter p;
               p.begin( btn );
               SFlags flags = Style_Default;
               if ( btn->isEnabled() )
                  flags |= Style_Enabled;
               if ( btn->hasFocus() )
                  flags |= Style_HasFocus;
               if ( btn->isDown() )
                  flags |= Style_Down;
               if ( highlightWidget == btn )
                  flags |= Style_MouseOver;
               if ( btn->state() == TQButton::On )
                  flags |= Style_On;
               else if ( btn->state() == TQButton::Off )
                  flags |= Style_Off;
               if ( isRadio )
                  drawControl( CE_RadioButton, &p, ceData, elementFlags, TQRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags, TQStyleOption::Default, btn );
               else
                  drawControl( CE_CheckBox, &p, ceData, elementFlags, TQRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags, TQStyleOption::Default, btn );
               p.end();
            }
            return false;
         }
         return false;
      case TQEvent::MouseButtonPress:
//	 tqWarning("class: %s, name: %s",obj->className(), obj->name());
      if ( optionHandler->style() > Panther && ::tqt_cast<TQToolBar*>(obj))
         {
            TQMouseEvent *mev = (TQMouseEvent *) ev;
            if (mev->button() != TQt::LeftButton)
               return false;
            mouseButtonPressed_ = true;
            cursorPos_ = mev->globalPos();
            TQTimer::singleShot(50,this,SLOT(fakeMouse()));
            return true; // fire this event
         }
         if ( ::tqt_cast<TQScrollBar*>(obj) && ((TQMouseEvent*)ev)->button() != TQt::RightButton)
         {
            TQScrollBar * sb = ( TQScrollBar * ) obj;
            activeScroller = NULL;
            sb->repaint( false );
            return false;
         }
         else if (obj->inherits( "KAnimWidget" ))
         {
            ((TQFrame *)obj)->setFrameStyle(TQFrame::StyledPanel | TQFrame::Sunken);
            return false;
         }
         return false;
      case TQEvent::MouseButtonRelease:
         if ( mouseButtonPressed_ )
         {
            mouseButtonPressed_= false;
         }
         if ( ::tqt_cast<TQScrollBar*>(obj) )
         {
            TQScrollBar * sb = ( TQScrollBar * ) obj;
            TQMouseEvent * me = ( TQMouseEvent * ) ev;
            if ( sb == highlightWidget)
            {
               if ( sb->rect().contains( me->pos() ) )
               {
                  activeScroller = sb;
                  sb->repaint( false );
               }
               else
               {
                  // this assumes, scrollers are right/bottom to scrollview
                  if ( ((sb->orientation() == Vertical) && (me->pos().x() < 0)) || ((sb->orientation() == Horizontal) && (me->pos().y() < 0)) )
                  {
                     optionHandler->setScrollerActive();
                     sb->repaint( false );
                  }
               }
            }
            return false;
         }
         else if ( ::tqt_cast<TQHeader*>(obj) && obj->parent() && ::tqt_cast<TQListView*>(obj->parent()))
         {
            TQMouseEvent * me = ( TQMouseEvent * ) ev;
            headerSortID = ((TQHeader*)obj)->sectionAt( me->x() + ((TQHeader*)obj)->offset());
            return false;
         }
         else if (obj->inherits( "KAnimWidget" )){
               ((TQFrame *)obj)->setFrameShape(TQFrame::NoFrame);
               return false;
         }
         return false;
      case TQEvent::FocusIn:
         if (optionHandler->AnimateButton() && ::tqt_cast<TQPushButton*>(obj))
         {
            fadeIn((TQPushButton*)obj);
            return false;
         }
         if ( obj->inherits( "TQLineEdit" ) )
         {
            TQObject *daddy = obj->parent();
            if ( daddy && daddy->inherits( "TQSpinWidget" ))
               ((TQWidget*)daddy)->repaint(false);
            else
               ((TQWidget*)obj)->repaint(false);
            return false;
         }
         return false;
      case TQEvent::FocusOut:
         if (optionHandler->AnimateButton() && ::tqt_cast<TQPushButton*>(obj))
         {
               fadeOut((TQPushButton*)obj);
               return false;
         }
         if ( obj->inherits( "TQLineEdit" ) )
         {
            if ( obj->parent() && obj->parent()->inherits( "TQSpinWidget" ))
               ((TQWidget*)obj->parent())->repaint(false);
            else
               ((TQWidget*)obj)->repaint(false);
            return false;
         }
         return false;
      case TQEvent::Move:
         if ( !(::tqt_cast<TQToolBar*>(obj) || obj->inherits( "KActiveLabel" )))
            return false;
      case TQEvent::Show:
         if (optionHandler->style() == Tiger && ::tqt_cast<TQToolBar*>(obj))
         {
            TQToolBar *tb = (TQToolBar*)obj;
            TQPoint pt = tb->mapTo(tb->topLevelWidget(), TQPoint(0,0));
            if (pt.y() == 0)
            {
               activeToolbarPix = TQPixmap(32,tb->height());
               KPixmapEffect::gradient(activeToolbarPix, optionHandler->aDecoColor1(), optionHandler->aDecoColor2(), KPixmapEffect::VerticalGradient, 0);
               TQPainter painter(&activeToolbarPix);
               painter.setPen( optionHandler->aDecoColor2().dark(130) );
               painter.drawLine ( 0, tb->height()-1, 31, tb->height()-1 );
               painter.end();
               tb->installEventFilter(eventKiller);
               if (tb->isActiveWindow())
               {
                  tb->setPaletteBackgroundColor(optionHandler->aDecoColor2());
                  tb->setPaletteBackgroundPixmap(activeToolbarPix);
               }
               else
               {
                  TQPalette pal( tb->palette() );
                  pal.setColor( TQColorGroup::Background, tqApp->palette().color(TQPalette::Active, TQColorGroup::Background) );
                  pal.setBrush ( TQColorGroup::Background, tqApp->palette().brush(TQPalette::Active, TQColorGroup::Background) );
                  tb->setPalette( pal );
               }
               tb->removeEventFilter(eventKiller);
            }
            else
            {
               TQPalette pal( tb->palette() );
               pal.setBrush ( TQColorGroup::Background, tqApp->palette().brush(TQPalette::Active, TQColorGroup::Background) );
               tb->installEventFilter(eventKiller);
               tb->setPalette( pal );
               tb->removeEventFilter(eventKiller);
            }
         }
         if (optionHandler->AnimateButton() && ::tqt_cast<TQPushButton*>(obj))
         {
            ButtonFadeInfo *bfi_ = bfi[((TQPushButton*)obj)->winId()];
            if (bfi_)
               return false;
            bfi_ = new ButtonFadeInfo();
            bfi.insert(((TQPushButton*)obj)->winId(),bfi_);
            if (((TQPushButton*)obj)->isDefault())
               fadeIn((TQPushButton*)obj);
            return false;
         }
         if (::tqt_cast<TQProgressBar*>(obj))
         {
            progAnimWidgets[(TQWidget*)obj] = 0;
            return false;
         }
         if ( !qstrcmp(obj->name(), "tde toolbar widget") )
         {
            TQWidget* lb = static_cast<TQWidget*>(obj);
            if (lb->backgroundMode() == TQt::PaletteButton)
               lb->setBackgroundMode(TQt::PaletteBackground);
            lb->removeEventFilter(this);
            return false;
         }
         else if ( !obj->inherits( "KActiveLabel" ))
            return false;
      case TQEvent::Resize:{
         TQResizeEvent* rev = (TQResizeEvent*) ev;
         if (::tqt_cast<TQPopupMenu*>(obj) && optionHandler->MenuBackground() == Gradient)
         {
            KPixmap tmpPix = TQPixmap(rev->size().width(),32);
            ((TQWidget *)obj)->setPaletteBackgroundPixmap(KPixmapEffect::unbalancedGradient(tmpPix, optionHandler->Color(), optionHandler->Color2(), KPixmapEffect::HorizontalGradient, 100, 100));
         }
         else if (optionHandler->style() == Tiger && ::tqt_cast<TQToolBar*>(obj) && rev->size().height() != rev->oldSize().height())
         {
            TQToolBar *tb = (TQToolBar*)obj;
            TQPoint pt = tb->mapTo(tb->topLevelWidget(), TQPoint(0,0));
            if (pt.y() == 0)
            {
               activeToolbarPix = TQPixmap(32,rev->size().height());
               KPixmapEffect::gradient(activeToolbarPix, optionHandler->aDecoColor1(), optionHandler->aDecoColor2(), KPixmapEffect::VerticalGradient, 0);
               TQPainter painter(&activeToolbarPix);
               painter.setPen( optionHandler->aDecoColor2().dark(130) );
               painter.drawLine ( 0, rev->size().height()-1, 31, rev->size().height()-1 );
               painter.end();
               tb->installEventFilter(eventKiller);
               if (tb->isActiveWindow())
               {
                  tb->setPaletteBackgroundColor(optionHandler->aDecoColor2());
                  tb->setPaletteBackgroundPixmap(activeToolbarPix);
               }
               else
               {
                  TQPalette pal( tb->palette() );
                  pal.setColor( TQColorGroup::Background, tqApp->palette().color(TQPalette::Active, TQColorGroup::Background) );
                  pal.setBrush ( TQColorGroup::Background, tqApp->palette().brush(TQPalette::Active, TQColorGroup::Background) );
                  tb->setPalette( pal );
               }
               tb->removeEventFilter(eventKiller);
            }
            else
            {
               TQPalette pal( tb->palette() );
               pal.setBrush ( TQColorGroup::Background, tqApp->palette().brush(TQPalette::Active, TQColorGroup::Background) );
               tb->installEventFilter(eventKiller);
               tb->setPalette( pal );
               tb->removeEventFilter(eventKiller);
            }
         }
         /*hmhmhmm... this may break qgroupbox children?!?*/
         else if (::tqt_cast<TQGroupBox*>(obj))
         {
            TQGroupBox* gb = (TQGroupBox*)(obj);
            if(gb->title().isEmpty()) return false;
            TQResizeEvent * e = (TQResizeEvent*)ev;
            int fm = gb->fontMetrics().height()+(gb->isCheckable()?4:1);
            gb->setFrameRect(TQRect(gb->rect().x(), gb->rect().y()+fm, e->size().width(), e->size().height()-fm/*-gb->frameWidth()*/));
            if(gb->layout())
               gb->layout()->setGeometry(TQRect(gb->rect().x(), gb->rect().y(), e->size().width(), e->size().height()));
            return true;
         }
         else if ( obj->inherits( "KActiveLabel" ))
         {
            TQWidget * w = ( TQWidget * ) obj;
            TQPalette pal( w->palette() );
            TQPixmap *tile = pal.brush( TQPalette::Active, TQColorGroup::Background ).pixmap();
            if ( tile )
            {
               TQSize sz( ev->type() == TQEvent::Resize ? rev->size() : w->size() );
               TQPixmap pix( sz.width(), sz.height() );
               TQPainter p;
               if (optionHandler->style() == Brushed)
               {
                  p.begin( &pix );
                  // calc brush offsets
                  TQWidget *window = w->topLevelWidget();
                  int leftWidth;
                  int rightWidth;
                  if (window)
                  {
                     TQPoint zero = w->mapTo(window, TQPoint(0,0));
                     leftWidth = (window->width()-1024)/2 - zero.x();
                     rightWidth = pix.width() - (1024 + leftWidth);
                     if (leftWidth > 0)
                        p.drawTiledPixmap(0, 0, leftWidth, sz.height(), plainBrush);
                     p.drawTiledPixmap(leftWidth>0?leftWidth:0, 0,
                                       pix.width()-(leftWidth>0?leftWidth:0)-(rightWidth>0?rightWidth:0), sz.height(),
                                       gradBrush,leftWidth>0?0:(zero.x()-(window->width()-1024)/2));
                     if (rightWidth > 0)
                        p.drawTiledPixmap(pix.width()-rightWidth, 0, rightWidth, sz.height(), plainBrush);
                  }
                  else if (pix.width() > 1024)
                  {
                     leftWidth = (pix.width()-1024)/2;
                     rightWidth = pix.width() - leftWidth;
                     p.drawTiledPixmap(0, 0, leftWidth, sz.height(), plainBrush);
                     p.drawTiledPixmap(leftWidth, 0, 1024, sz.height(), gradBrush);
                     p.drawTiledPixmap(leftWidth + 1024, 0, rightWidth, sz.height(), plainBrush);
                  }
                  else
                     p.drawTiledPixmap(0, 0, pix.width(), sz.height(), gradBrush, (1024-pix.width())/2, 0);
                  p.end();
                  TQBrush brush( pal.active().background(), pix );
                  pal.setBrush( TQColorGroup::Base, brush );
                  w->setPalette( pal );
               }
               else
               {
                  p.begin(w);
                  p.drawTiledPixmap(TQRect(0,0,sz.width(),sz.height()), *tile, w->backgroundOffset());
               }
            }
            return false;
         }
         else if ((optionHandler->style() == Brushed) && obj->isWidgetType() && ((TQWidget*)obj)->isTopLevel() &&
                  !(::tqt_cast<TQPopupMenu*>(obj) || ::tqt_cast<TQMenuBar*>(obj) || ((TQWidget*)obj)->isDesktop () || ::tqt_cast<TQListBox*>(obj) ||
                  obj->inherits("TQTipLabel") || obj->inherits("AlphaWidget") || obj->inherits("ScrollWidget") ) && (ev->type() == TQEvent::Show ||
                  rev->size().width() != rev->oldSize().width()))
         {
            TQWidget* widget = (TQWidget*)obj;
            // create new brushpix
         TQPixmap tmpBrushPix(ev->type() == TQEvent::Show?widget->width():rev->size().width(), plainBrush.height());
            TQPainter lightMe(&tmpBrushPix);
            // calc brush offsets
            int tmpWidth;
            if ((tmpWidth = tmpBrushPix.width()) > 1024)
            {
               int leftWidth = (tmpWidth-1024)/2;
               int rightWidth = tmpWidth - leftWidth;
               lightMe.drawTiledPixmap(0, 0, leftWidth, plainBrush.height(), plainBrush,256-leftWidth,0);
               lightMe.drawPixmap(leftWidth, 0, gradBrush);
               lightMe.drawTiledPixmap(leftWidth + 1024, 0, rightWidth, plainBrush.height(), plainBrush);
            }
            else
               lightMe.drawPixmap(0, 0, gradBrush, (1024-tmpWidth)/2, 0, tmpWidth);
            lightMe.end();
            //update palette
            TQPalette pal( tqApp->palette());
            TQBrush brush( pal.active().background(), tmpBrushPix );
            pal.setBrush ( TQColorGroup::Background, brush );
            //reset apps palette
            tqApp->installEventFilter(eventKiller); // pssst... don't let anyone know...
            tqApp->setPalette(pal);
            pal = TQPalette(widget->palette());
            pal.setBrush ( TQColorGroup::Background, brush );
            widget->installEventFilter(eventKiller); // pssst... don't let anyone know...
            widget->setPalette(pal);
            widget->removeEventFilter(eventKiller); // ...that we just replaced the palette
            TQObjectList *kids = widget->queryList("TQWidget"); //TODO: implement a faster version, depending on ::tqt_cast<TQWidget*>()
            for (uint i= 0; i < kids->count(); i++)
            {
               TQWidget *kid = (TQWidget*)kids->at(i);
               if (kid && kid->paletteBackgroundPixmap() && !(kid->isTopLevel() || kid->inherits( "KonqIconViewWidget" ) || kid->inherits( "tdehtml") || kid->inherits( "KActiveLabel") || qstrcmp( kid->name(), "_B_ALI_HEADER" ) == 0 ||  (kid->parentWidget() && kid->parentWidget()->inherits("Thumbnail") || kid->parentWidget()->inherits("MarkListItem")) ))
               {
               //we can loose those kids anytime - especially if the user plays on konqueror...
                  if (::tqt_cast<TDEToolBarButton*>(kid))
                     kid->setErasePixmap(tmpBrushPix);
                  else
                  {
                     pal = TQPalette(kid->palette());
                     pal.setBrush ( TQColorGroup::Background, brush );
                     kid->installEventFilter(eventKiller); // pssst... don't let anyone know...
                     kid->setPalette(pal);
                     kid->removeEventFilter(eventKiller); // ...that we just replaced the palette
                  }
               }
            }
            delete kids;
            tqApp->removeEventFilter(eventKiller); // ...that we just replaced the palette
            return false;
         }
         return false;
      }
      case TQEvent::Hide:
         if (optionHandler->AnimateButton() && ::tqt_cast<TQPushButton*>(obj))
         {
            ButtonFadeInfo *bfi_ = bfi[((TQPushButton*)obj)->winId()];
            if (bfi_)
            {
               obj->killTimer(bfi_->timerId);
               // tqWarning("%u: stopped (%d)", ((TQPushButton*)obj)->winId(), bfi_->timerId);
               bfi_->index=0;
               bfi_->timerId=0;
            }
         }
      case TQEvent::ApplicationPaletteChange:
         if ( obj->inherits( "TQTipLabel" ) )
         {
            ( ( TQWidget* ) obj ) ->setPalette( tooltipPalette );
            return true;
         }
         return false;
      case TQEvent::PaletteChange:
         if (obj->inherits("TQStatusBar"))
         {
            obj->installEventFilter(eventKiller);
            ((TQWidget*)obj)->setPalette(tqApp->palette());
            obj->removeEventFilter(eventKiller);
            return true;
         }
         if ( obj->inherits( "TQTipLabel" ) )
         {
            ( ( TQWidget* ) obj ) ->setPalette( tooltipPalette );
            return true;
         }
         if (obj->inherits("KCalcButton"))
         {
            TQWidget *w = (TQWidget*)obj;
            TQPalette pal( w->palette() );
            pal.setBrush( TQColorGroup::Background, tqApp->palette().brush(TQPalette::Active, TQColorGroup::Background));
            w->installEventFilter(eventKiller);
            w->setPalette( pal );
            w->removeEventFilter(eventKiller);
            w->setBackgroundOrigin( TQWidget::WindowOrigin );
            return true;
         }
         return false;
      case TQEvent::WindowActivate:
         if (optionHandler->style() == Tiger && ::tqt_cast<TQToolBar*>(obj))
         {
            TQToolBar *tb = (TQToolBar*)obj;
            TQPoint pt = tb->mapTo(tb->topLevelWidget(), TQPoint(0,0));
            if (pt.y() == 0)
            {
               tb->installEventFilter(eventKiller);
               tb->setPaletteBackgroundColor(optionHandler->aDecoColor2());
               tb->setPaletteBackgroundPixmap(activeToolbarPix);
               tb->removeEventFilter(eventKiller);
            }
         }
         return false;
      case TQEvent::WindowDeactivate:
         if (optionHandler->style() == Tiger && ::tqt_cast<TQToolBar*>(obj))
         {
            TQToolBar *tb = (TQToolBar*)obj;
            TQPoint pt = tb->mapTo(tb->topLevelWidget(), TQPoint(0,0));
            if (pt.y() == 0)
            {
               TQPalette pal( tb->palette() );
               pal.setColor( TQColorGroup::Background, tqApp->palette().color(TQPalette::Active, TQColorGroup::Background) );
               pal.setBrush ( TQColorGroup::Background, tqApp->palette().brush(TQPalette::Active, TQColorGroup::Background) );
               tb->installEventFilter(eventKiller);
               tb->setPalette( pal );
               obj->removeEventFilter(eventKiller);
            }
         }
         return false;
      default:
         return false;
   }
}

void LiquidStyle::fakeMouse()
{
   if (mouseButtonPressed_) // delayed mousepress for move event
   {
      TQCursor::setPos ( cursorPos_ );
      XTestFakeButtonEvent(tqt_xdisplay(),1, false, 0);
      XTestFakeKeyEvent(tqt_xdisplay(),XKeysymToKeycode(tqt_xdisplay(), XK_Alt_L), true, 0);
      XTestFakeButtonEvent(tqt_xdisplay(),1, true, 0);
      XTestFakeKeyEvent(tqt_xdisplay(),XKeysymToKeycode(tqt_xdisplay(), XK_Alt_L), false, 0);
      XFlush(tqt_xdisplay());
   }
}

void LiquidStyle::fadeIn(TQPushButton *button)
{
   ButtonFadeInfo *bfi_ = bfi[button->winId()];
   if (!bfi_)
   {
      bfi_ = new ButtonFadeInfo();
      bfi.insert(button->winId(),bfi_);
   }
   bfi_->fadeIn = true;
   if (bfi_->timerId == 0)
   {
      bfi_->index = 0;
      bfi_->timerId = button->startTimer(button->isDefault()?100:50);
      // tqWarning("%u: started (%d)", button->winId(), bfi_->timerId);
   }
}

void LiquidStyle::fadeOut(TQPushButton *button)
{
   ButtonFadeInfo *bfi_ = bfi[button->winId()];
   if (!bfi_)
   {
      bfi_ = new ButtonFadeInfo();
      bfi.insert(button->winId(),bfi_);
   }
   bfi_->fadeIn = false;
   if (bfi_->timerId == 0)
   {
      bfi_->index = 9;
      bfi_->timerId = button->startTimer(50);
      // tqWarning("%u: started (%d)", button->winId(), bfi_->timerId);
   }
}

BMShower::BMShower(TQObject *parent) : TQObject(parent)
{
}

bool BMShower::eventFilter( TQObject *obj, TQEvent *ev )
{
   if (ev->type() == TQEvent::Show && (obj->isWidgetType() && ((TQWidget*)obj)->isTopLevel() &&
         !(::tqt_cast<TQPopupMenu*>(obj) || ::tqt_cast<TQMenuBar*>(obj) || ((TQWidget*)obj)->isDesktop () || ::tqt_cast<TQListBox*>(obj) ||
         obj->inherits("TQTipLabel") || obj->inherits("AlphaWidget") || obj->inherits("ScrollWidget") )))
   {
      TQResizeEvent* rev = new TQResizeEvent(((TQWidget*)obj)->size(), TQSize(0,0));
      parent()->eventFilter( obj, rev );
      obj->removeEventFilter(this);
      delete rev;
   }
   return false;
}
