#include <tqvbox.h>
#include <tqlabel.h>
#include <tqsplitter.h>
#include <tqtimer.h>
#include <tqwidgetstack.h>

#include <kpushbutton.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeaction.h>
#include <tdeactionclasses.h>
#include <tdeapplication.h>
#include <kdebug.h>
#include <tdeparts/part.h>
#include <ktrader.h>
#include <klibloader.h>
#include <kstatusbar.h>

#include <apt-pkg/packagemanager.h>
#include <apt-front/manager.h>
#include <apt-front/init.h>
#include <apt-front/cache/entity/package.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>
#include <apt-front/predicate/factory.h>

#include <adept/acqprogresswidget.h>
#include <adept/progress.h>
#include <adept/utils.h>

#include "app.h"

using namespace aptFront;
using namespace aptFront::cache;
using namespace adept;

void WaitForLister::waiting()
{
    kdDebug() << "WaitForLister::waiting()" << endl;
    if (app->m_list->searchView()->lister()->busy())
        TQTimer::singleShot( 100, this, TQT_SLOT( waiting() ) );
    else {
        TQTimer::singleShot( 0, app, slot );
        deleteLater();
    }
}

TestApp::TestApp()
{
    m_all = new TQVBox( this );
    m_stack = new TQWidgetStack( m_all );

    m_stack->addWidget( m_loading = new TQLabel( i18n( "Loading, please wait..." ), m_stack ) );
    m_loading->setAlignment( TQt::AlignHCenter | TQt::AlignVCenter );

    m_buttons = new TQHBox( m_all );
    TQLabel *space = new TQLabel( m_buttons ); // spacing
    m_next = new KPushButton( i18n( "Next" ), m_buttons );
    m_quit = new KPushButton( i18n( "Quit" ), m_buttons );
    m_next->setEnabled( false );
    m_quit->setEnabled( false );

    m_buttons->setSpacing( 2 );
    m_buttons->setMargin( 2 );
    TQSizePolicy buttons( TQSizePolicy::Preferred, TQSizePolicy::Fixed, false );
    m_buttons->setSizePolicy( buttons );
    m_next->setSizePolicy( buttons );
    m_quit->setSizePolicy( buttons );
    space->setSizePolicy( TQSizePolicy(
                               TQSizePolicy::Expanding,
                               TQSizePolicy::Fixed, false ) );

    setStandardToolBarMenuEnabled( false );
    createStandardStatusBarAction();
    setupActions();
    setupGUI( Keys|StatusBar|Save|Create );
    delete toolBar();

    Application::setStatusBar( statusBar() );

    TQTimer::singleShot(
        0, this,
        TQT_SLOT( delayed() ) );

    setCentralWidget( m_all );
    setMinimumSize( 400, 300 );
}

void TestApp::delayed()
{
    initialize();
    observeComponent< component::State >();

    m_stack->addWidget( m_list = new adept::Browser( m_stack ) );
    m_stack->addWidget( m_bye = new TQLabel( i18n( "Update Complete" ),
                                            m_stack ) );
    m_stack->addWidget( m_start = new TQLabel( i18n( "Welcome to Adept Updater" ),
                                              m_stack ) );
    m_bye->setAlignment( TQt::AlignHCenter | TQt::AlignVCenter );
    m_start->setAlignment( TQt::AlignHCenter | TQt::AlignVCenter );

    m_list->searchView()->setUpgradeMode();

    m_stack->addWidget( m_progress = new adept::AcqProgressWidget( m_stack ) );
    m_stack->addWidget( m_commitProgress = new CommitProgress( m_stack ) );

    m_stack->raiseWidget( m_start );

    statusBar()->clear();
    notifyPostChange(0);
    start();
}

void TestApp::setupActions()
{
    KStdAction::quit( TQT_TQOBJECT(kapp), TQT_SLOT( quit() ), actionCollection() );
    m_undo = KStdAction::undo( TQT_TQOBJECT(this), TQT_SLOT( undo() ), actionCollection() );
    m_redo = KStdAction::redo( TQT_TQOBJECT(this), TQT_SLOT( redo() ), actionCollection() );
    setHistoryEnabled( false );
    createStandardStatusBarAction();
}

void TestApp::setHistoryEnabled( bool e ) {
    if (e && history() ) {
        m_undo->setEnabled( history()->canUndo() );
        m_redo->setEnabled( history()->canRedo() );
    } else {
        m_undo->setEnabled( false );
        m_redo->setEnabled( false );
    }
}

void TestApp::notifyPreChange( component::Base *b )
{
    Application::notifyPreChange( b );
    checkpoint();
}

void TestApp::notifyPostChange( component::Base *b )
{
    Application::notifyPostChange( b );
    m_list->searchView()->lister()->scheduleRebuild(); // rebuild on change...
}

void TestApp::setNext( TQString s, const char *slot, TQString q, const char *quits ) {
    disconnect( m_next, TQT_SIGNAL( clicked() ), 0, 0 );
    m_next->setText( s );
    m_next->setEnabled( slot );
    if ( slot )
        connect( m_next, TQT_SIGNAL( clicked() ), this, slot );

    disconnect( m_quit, TQT_SIGNAL( clicked() ), 0, 0 );
    m_quit->setEnabled( quits );
    m_quit->setText( q );
    if ( quits )
        connect( m_quit, TQT_SIGNAL( clicked() ), this, quits );
}

void TestApp::disableNext() {
    setNext( i18n( "Next" ), 0 );
}

void TestApp::disableButtons() {
    disableNext();
    m_quit->setEnabled( false );
}

void TestApp::start() {
//    disableNext();
    update();
//    setNext( i18n( "Fetch List of Updates" ), TQT_SLOT( update() ),
//             i18n( "Skip Fetching List" ), TQT_SLOT( postUpdate() ) );
}

void TestApp::update() {
    kdDebug() << "TestApp::update" << endl;
    disableButtons();

    aptFront::Manager m;
    m.setProgressCallback( m_progress->callback() );
    m.setUpdateInterval( 100000 );
    kdDebug() << "manager set up" << endl;
    try {
        m_stack->raiseWidget( m_progress );
        m.update();
    } catch ( exception::OperationCancelled ) {
    } catch ( ... ) {
        KMessageBox::sorry(
            this, i18n( "There was an error downloading updates. " ),
            i18n( "Could not fetch updates" ) );
    }
    postUpdate();
}

void TestApp::postUpdate() {
    cache::Global::get().state().distUpgrade();
    if ( cache::Global::get().state().upgradableCount() > 0 ) {
        m_list->searchView()->lister()->scheduleRebuild();
        m_stack->raiseWidget( m_list );
        setHistoryEnabled( true );
        setNext( i18n( "Apply Updates" ), TQT_SLOT( commit() ) );
    } else {
        m_bye->setText( i18n( "Nothing to Update" ) );
        m_stack->raiseWidget( m_bye );
        disableNext();
        // setNext( i18n( "Nothing to do, Quit" ), TQT_SLOT( close() ) );
        m_quit->setText( i18n( "Quit" ) );
        m_quit->setEnabled( true );
    }
}

void TestApp::commit() {
    kdDebug() << "TestApp::commit" << endl;
    disableButtons();
    setHistoryEnabled( false );
    if (m_list->searchView()->lister()->busy()) {
        new WaitForLister( this, TQT_SLOT( commit() ) );
        return;
    }

    aptFront::Manager m;
    m.setProgressCallback( m_progress->callback() );
    m.setUpdateInterval( 100000 );
    try {
        m_stack->raiseWidget( m_progress );
        m.download();
        m_stack->raiseWidget( m_commitProgress );
        m.commit();
    } catch ( exception::OperationCancelled ) {
    } catch ( ... ) {
        KMessageBox::sorry(
            this, i18n( "There was an error commiting changes. "
                        "Possibly there was a problem downloading some "
                        "packages or the commit would break packages. " ),
            i18n( "Could not commit changes" ) );
    }

    m_stack->raiseWidget( m_bye );
    disableNext();
    m_quit->setText( i18n( "Quit" ) );
    m_quit->setEnabled( true );
    notifyPostChange( 0 );
}

#include "app.moc"
