/* -*- C++ -*- */
#ifndef APP_H
#define APP_H

#include <tdemainwindow.h>
#include <tdeparts/part.h>
#include <tdeactionclasses.h>
#include <tdecmdlineargs.h>
#include <apt-front/cache/observer.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>
#include <adept/view.h>
#include <adept/commitprogress.h>
#include <adept/application.h>

#include <adept/acqprogresswidget.h>

class TQVBox;
class TQWidgetStack;
class TQSplitter;
class TDEAction;
class KPushButton;
namespace adept {
class AcqProgressWidget;
}

using namespace aptFront;
using namespace adept;

class App : public TDEMainWindow, Application {
    Q_OBJECT
  
public:
    void setupActions();
    ExtTerminalInterface *terminal();
	App( TDECmdLineArgs *a );
signals:
  void imDone();
protected slots:
    void delayed();
  void handleDone();
protected:
    friend class WaitForLister;

    TQWidgetStack *m_stack;
    TQVBox *m_all;

    // stacked widgets
    adept::AcqProgressWidget *m_progress;
    adept::CommitProgress *m_commitProgress;

    bool updating;
};

#endif
