/***************************************************************************
 *
 * knetworkmanager-connection_setting_ppp.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* NM headers */
#include <nm-setting-ppp.h>

/* qt headers */
#include <tqhostaddress.h>
#include <tqvariant.h>

/* kde headers */
#include <kdebug.h>
#include <tdelocale.h>

/* TQT_DBus headers*/
#include <tqdbusdata.h>
#include <tqdbusdatamap.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_ppp.h"

using namespace ConnectionSettings;

/*
	class PPP
*/
PPP::PPP(Connection* conn)
: ConnectionSetting(conn, NM_SETTING_PPP_SETTING_NAME),
    _noauth(false),
    _refuse_eap(false),
    _refuse_pap(false),
    _refuse_chap(false),
    _refuse_mschap(false),
    _refuse_mschapv2(false),
    _nobsdcomp(false),
    _nodeflate(false),
    _novjcomp(false),
    _require_mppe(false),
    _require_mppe_128(false),
    _mppe_stateful(false),
    _require_mppc(false),
    _crtscts(false),
    _baud(0),
    _mru(0),
    _mtu(0),
    _lcp_echo_failure(0),
    _lcp_echo_interval(0)
{
	// set defaults
}

bool
PPP::getNoAuth() const
{
	return _noauth;
}

void
PPP::setNoAuth(bool noauth)
{
	_noauth = noauth;
}

bool
PPP::getRefuseEAP() const
{
	return _refuse_eap;
}

void
PPP::setRefuseEAP(bool refuse_eap)
{
	_refuse_eap = refuse_eap;
}

bool
PPP::getRefusePAP() const
{
	return _refuse_pap;
}

void
PPP::setRefusePAP(bool refuse_pap)
{
	_refuse_pap = refuse_pap;
}

bool
PPP::getRefuseChap() const
{
	return _refuse_chap;
}

void
PPP::setRefuseChap(bool refuse_chap)
{
	_refuse_chap = refuse_chap;
}

bool
PPP::getRefuseMSChap() const
{
	return _refuse_mschap;
}

void
PPP::setRefuseMSChap(bool refuse_mschap)
{
	_refuse_mschap = refuse_mschap;
}

bool
PPP::getRefuseMSChapV2() const
{
	return _refuse_mschapv2;
}

void
PPP::setRefuseMSChapV2(bool refuse_mschapv2)
{
	_refuse_mschapv2 = refuse_mschapv2;
}

bool
PPP::getNoBSDComp() const
{
	return _nobsdcomp;
}

void
PPP::setNoBSDComp(bool nobsdcomp)
{
	_nobsdcomp = nobsdcomp;
}

bool
PPP::getNoDeflate() const
{
	return _nodeflate;
}

void
PPP::setNoDeflate(bool nodeflate)
{
	_nodeflate = nodeflate;
}

bool
PPP::getNoVJComp() const
{
	return _novjcomp;
}

void
PPP::setNoVJComp(bool novjcomp)
{
	_novjcomp = novjcomp;
}

bool
PPP::getRequireMPPE() const
{
	return _require_mppe;
}

void
PPP::setRequireMPPE(bool require_mppe)
{
	_require_mppe = require_mppe;
}

bool
PPP::getRequireMPPE128() const
{
	return _require_mppe_128;
}

void
PPP::setRequireMPPE128(bool require_mppe_128)
{
	_require_mppe_128 = require_mppe_128;
}

bool
PPP::getMPPEStateful() const
{
	return _mppe_stateful;
}

void
PPP::setMPPEStateful(bool b)
{
	_mppe_stateful = b;
}

bool
PPP::getRequireMPPC() const
{
	return _require_mppc;
}

void
PPP::setRequireMPPC(bool b)
{
	_require_mppc = b;
}

bool
PPP::getCRTSCTS() const
{
	return _crtscts;
}

void
PPP::setCRTSCTS(bool b)
{
	_crtscts = b;
}

TQ_INT32
PPP::getBaud() const
{
	return _baud;
}

void
PPP::setBaud(TQ_INT32 i)
{
	_baud = i;
}

TQ_INT32
PPP::getMRU() const
{
	return _mru;
}

void
PPP::setMRU(TQ_INT32 i)
{
	_mru = i;
}

TQ_INT32
PPP::getMTU() const
{
	return _mtu;
}

void
PPP::setMTU(TQ_INT32 i)
{
	_mtu = i;
}

TQ_INT32
PPP::getLCPEchoFailure() const
{
	return _lcp_echo_failure;
}

void
PPP::setLCPEchoFailure(TQ_INT32 i)
{
	_lcp_echo_failure = i;
}

TQ_INT32
PPP::getLCPEchoInterval() const
{
	return _lcp_echo_interval;
}

void
PPP::setLCPEchoInterval(TQ_INT32 i)
{
	_lcp_echo_interval = i;
}

bool
PPP::isValid() const
{
	return true;
}

SettingsMap
PPP::toMap() const
{
	SettingsMap map;

	// TODO
	map.insert(NM_SETTING_PPP_NOAUTH, TQT_DBusData::fromBool(_noauth));
	map.insert(NM_SETTING_PPP_REFUSE_EAP, TQT_DBusData::fromBool(_refuse_eap));
	map.insert(NM_SETTING_PPP_REFUSE_PAP, TQT_DBusData::fromBool(_refuse_pap));
	map.insert(NM_SETTING_PPP_REFUSE_CHAP, TQT_DBusData::fromBool(_refuse_chap));
	map.insert(NM_SETTING_PPP_REFUSE_MSCHAP, TQT_DBusData::fromBool(_refuse_mschap));
	map.insert(NM_SETTING_PPP_NOBSDCOMP, TQT_DBusData::fromBool(_nobsdcomp));
	map.insert(NM_SETTING_PPP_NODEFLATE, TQT_DBusData::fromBool(_nodeflate));
	map.insert(NM_SETTING_PPP_NO_VJ_COMP, TQT_DBusData::fromBool(_novjcomp));
	map.insert(NM_SETTING_PPP_REQUIRE_MPPE, TQT_DBusData::fromBool(_require_mppe));
	map.insert(NM_SETTING_PPP_REQUIRE_MPPE_128, TQT_DBusData::fromBool(_require_mppe_128));
	map.insert(NM_SETTING_PPP_MPPE_STATEFUL, TQT_DBusData::fromBool(_mppe_stateful));
	map.insert(NM_SETTING_PPP_CRTSCTS, TQT_DBusData::fromBool(_crtscts));
	map.insert(NM_SETTING_PPP_BAUD, TQT_DBusData::fromUInt32(_baud));
	map.insert(NM_SETTING_PPP_MRU, TQT_DBusData::fromUInt32(_mru));
	map.insert(NM_SETTING_PPP_MTU, TQT_DBusData::fromUInt32(_mtu));
	map.insert(NM_SETTING_PPP_LCP_ECHO_FAILURE, TQT_DBusData::fromUInt32(_lcp_echo_failure));
	map.insert(NM_SETTING_PPP_LCP_ECHO_INTERVAL, TQT_DBusData::fromUInt32(_lcp_echo_interval));

	return map;
}

SettingsMap
PPP::toSecretsMap(bool with_settings) const
{
	SettingsMap map;

	// first serialize the settings if needed
	if (with_settings)
		map = toMap();

	return map;
}

bool
PPP::fromSecretsMap(const SettingsMap& map)
{
	for (SettingsMap::ConstIterator it = map.begin(); it != map.end(); ++it)
	{
		// TODO
		/*if (it.key() == NM_SETTING_PPP_PASSWORD)
			setPassword(it.data().toString());
		else
			kdWarning() << k_funcinfo << " Unknown setting: " << it.key() << endl;
		*/
	}
	return true;
}

void
PPP::fromMap(const SettingsMap& map)
{
	for (SettingsMap::ConstIterator it = map.begin(); it != map.end(); ++it)
	{
		// TODO
		/*
		if (it.key() == NM_SETTING_PPP_NUMBER)
			setNumber(it.data().toString());
		else
			kdWarning() << k_funcinfo << " Unknown setting: " << it.key() << endl;
		*/
	}
}
