/***************************************************************************
                          kbpickicondlg.h  -  description
                             -------------------
    begin                : Sat Jul 21 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBPICKICONDLG_H
#define KBPICKICONDLG_H

#include <kdialogbase.h>

class TQWidget;
class TQStringList;
class TQPixmap;
class TDEListBox;

/**A dialog to pick an icon for a keyboard layout
  *@author Leonid Zeitlin
  */

class KBPickIconDlg : public KDialogBase  {
   Q_OBJECT
public: 
	KBPickIconDlg(const TQString &currentPath, const TQPixmap &currentPixmap,
	  TQWidget *parent=0, const char *name=0);
	~KBPickIconDlg();
  /** Get the path name of the selected icon. Returns empty string if no icon selected */
  TQString getIconPath();
  /** No descriptions */
  const TQPixmap* getIcon();
private: // Private attributes
  /**  */
  //TQStringList m_pathnames;
  //TQString m_iconpath;
  //TDEIconView *m_iconview;
  TDEListBox *lbIcons;
  //TQLabel *lblIcon;
  //TQRadioButton *rbFlags;
  //TQRadioButton *rbBrowse;
  void loadCountryFlags();
  void loadGkbCountryFlags();
  void showCurrentPath(const TQString &currentPath, const TQPixmap &currentPixmap);
private slots: // Private slots
  /** Browse for an arbitrary icon file */
  void slotBrowseForIcon();
  /** Respond to user selecting a flag in the icon view */
  //void slotFlagSelected(TQIconViewItem *item);
};

#endif
