/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef BIBTEXEXPORTER_H
#define BIBTEXEXPORTER_H

class TQCheckBox;
class KComboBox;

#include "exporter.h"

namespace Tellico {
  namespace Export {

/**
 * The Bibtex exporter shows a list of possible Bibtex fields next to a combobox of all
 * the current attributes in the collection. I had thought about the reverse - having a list
 * of all the attributes, with comboboxes for each Bibtex field, but I think this way is more obvious.
 *
 * @author Robby Stephenson
 */
class BibtexExporter : public Exporter {
Q_OBJECT
  

public:
  BibtexExporter();

  virtual bool exec();
  virtual TQString formatString() const;
  virtual TQString fileFilter() const;

  virtual TQWidget* widget(TQWidget* parent, const char* name=0);
  virtual void readOptions(TDEConfig*);
  virtual void saveOptions(TDEConfig*);

private:
  void writeEntryText(TQString& text, const Data::FieldVec& field, const Data::Entry& entry,
                      const TQString& type, const TQString& key);

  bool m_expandMacros;
  bool m_packageURL;
  bool m_skipEmptyKeys;

  TQWidget* m_widget;
  TQCheckBox* m_checkExpandMacros;
  TQCheckBox* m_checkPackageURL;
  TQCheckBox* m_checkSkipEmpty;
  KComboBox* m_cbBibtexStyle;
};

  } // end namespace
} // end namespace
#endif
