/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "statusbar.h"
#include "tellico_debug.h"
#include "progressmanager.h"
#include "tellico_debug.h"
#include "gui/progress.h"

#include <tdelocale.h>
#include <tdeapplication.h>
#include <kpushbutton.h>
#include <kiconloader.h>

#include <tqobjectlist.h>
#include <tqpainter.h>
#include <tqstyle.h>
#include <tqtimer.h>
#include <tqtooltip.h>

using Tellico::StatusBar;
StatusBar* StatusBar::s_self = 0;

StatusBar::StatusBar(TQWidget* parent_) : KStatusBar(parent_) {
  s_self = this;

  // don't care about text and id
  m_mainLabel = new KStatusBarLabel(TQString(), 0, this);
  m_mainLabel->setIndent(4);
  m_mainLabel->setAlignment(TQt::AlignLeft | TQt::AlignVCenter);
  addWidget(m_mainLabel, 3 /*stretch*/, true /*permanent*/);

  m_countLabel = new KStatusBarLabel(TQString(), 1, this);
  m_countLabel->setAlignment(TQt::AlignLeft | TQt::AlignVCenter);
  m_countLabel->setIndent(4);
  addWidget(m_countLabel, 0, true);

  m_progress = new GUI::Progress(100, this);
  addWidget(m_progress, 1, true);
  m_cancelButton = new KPushButton(SmallIcon(TQString::fromLatin1("cancel")), TQString(), this);
  TQToolTip::add(m_cancelButton, i18n("Cancel"));
  addWidget(m_cancelButton, 0, true);
  m_progress->hide();
  m_cancelButton->hide();

  ProgressManager* pm = ProgressManager::self();
  connect(pm, TQT_SIGNAL(signalTotalProgress(uint)), TQT_SLOT(slotProgress(uint)));
  connect(m_cancelButton, TQT_SIGNAL(clicked()), pm, TQT_SLOT(slotCancelAll()));
}

void StatusBar::polish() {
  KStatusBar::polish();

  int h = 0;
  TQObjectList* list = queryList(TQWIDGET_OBJECT_NAME_STRING, 0, false, false);
  for(TQObject* o = list->first(); o; o = list->next()) {
    int _h = TQT_TQWIDGET(o)->minimumSizeHint().height();
    if(_h > h) {
      h = _h;
    }
  }

  h -= 4; // hint from amarok, it's too big usually

  for(TQObject* o = list->first(); o; o = list->next()) {
    TQT_TQWIDGET(o)->setFixedHeight(h);
  }

  delete list;
}

void StatusBar::clearStatus() {
  setStatus(i18n("Ready."));
}

void StatusBar::setStatus(const TQString& status_) {
  // always add a space for asthetics
  m_mainLabel->setText(status_ + ' ');
}

void StatusBar::setCount(const TQString& count_) {
  m_countLabel->setText(count_ + ' ');
}

void StatusBar::slotProgress(uint progress_) {
  m_progress->setProgress(progress_);
  if(m_progress->isDone()) {
    m_progress->hide();
    m_cancelButton->hide();
  } else if(m_progress->isHidden()) {
    m_progress->show();
    if(ProgressManager::self()->anyCanBeCancelled()) {
      m_cancelButton->show();
    }
    kapp->processEvents(); // needed so the window gets updated ???
  }
}

void StatusBar::slotUpdate() {
/*
  myDebug() << "StatusBar::slotUpdate() - " << m_progress->isShown() << endl;
  if(m_progressBox->isEmpty()) {
    TQTimer::singleShot(0, m_progress, TQT_SLOT(hide()));
//    m_progressBox->hide();
  } else {
    TQTimer::singleShot(0, m_progress, TQT_SLOT(show()));
//    m_progressBox->show();
  }
*/
}

#include "statusbar.moc"
