/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2004  Alexander Dymo <cloudtemple@mskat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "cursoredit.h"

#include <tqmap.h>
#include <tqvariant.h>
#include <tqcursor.h>

#include <tdelocale.h>
#include <kdebug.h>

#include "property.h"

using namespace KoProperty;

//TQMap<TQString, TQVariant> *CursorEdit::m_spValues = 0;
Property::ListData *m_cursorListData = 0;


CursorEdit::CursorEdit(Property *property, TQWidget *parent, const char *name)
: ComboBox(property, parent, name)
{
	/*
	if(!m_spValues) {
		m_spValues = new TQMap<TQString, TQVariant>();
		(*m_spValues)[i18n("Arrow")] = TQt::ArrowCursor;
		(*m_spValues)[i18n("Up Arrow")] = TQt::UpArrowCursor;
		(*m_spValues)[i18n("Cross")] = TQt::CrossCursor;
		(*m_spValues)[i18n("Waiting")] = TQt::WaitCursor;
		(*m_spValues)[i18n("iBeam")] = TQt::IbeamCursor;
		(*m_spValues)[i18n("Size Vertical")] = TQt::SizeVerCursor;
		(*m_spValues)[i18n("Size Horizontal")] = TQt::SizeHorCursor;
		(*m_spValues)[i18n("Size Slash")] = TQt::SizeBDiagCursor;
		(*m_spValues)[i18n("Size Backslash")] = TQt::SizeFDiagCursor;
		(*m_spValues)[i18n("Size All")] = TQt::SizeAllCursor;
		(*m_spValues)[i18n("Blank")] = TQt::BlankCursor;
		(*m_spValues)[i18n("Split Vertical")] = TQt::SplitVCursor;
		(*m_spValues)[i18n("Split Horizontal")] = TQt::SplitHCursor;
		(*m_spValues)[i18n("Pointing Hand")] = TQt::PointingHandCursor;
		(*m_spValues)[i18n("Forbidden")] = TQt::ForbiddenCursor;
		(*m_spValues)[i18n("What's this")] = TQt::WhatsThisCursor;
	}*/

//! @todo NOT THREAD-SAFE
	if (!m_cursorListData) {
		TQValueList<TQVariant> keys;
		keys
			<< TQt::BlankCursor
			<< TQt::ArrowCursor
			<< TQt::UpArrowCursor
			<< TQt::CrossCursor
			<< TQt::WaitCursor
			<< TQt::IbeamCursor
			<< TQt::SizeVerCursor
			<< TQt::SizeHorCursor
			<< TQt::SizeBDiagCursor
			<< TQt::SizeFDiagCursor
			<< TQt::SizeAllCursor
			<< TQt::SplitVCursor
			<< TQt::SplitHCursor
			<< TQt::PointingHandCursor
			<< TQt::ForbiddenCursor
			<< TQt::WhatsThisCursor;
		TQStringList strings;
		strings << i18n("Mouse Cursor Shape", "No Cursor")
			<< i18n("Mouse Cursor Shape", "Arrow")
			<< i18n("Mouse Cursor Shape", "Up Arrow")
			<< i18n("Mouse Cursor Shape", "Cross")
			<< i18n("Mouse Cursor Shape", "Waiting")
			<< i18n("Mouse Cursor Shape", "I")
			<< i18n("Mouse Cursor Shape", "Size Vertical")
			<< i18n("Mouse Cursor Shape", "Size Horizontal")
			<< i18n("Mouse Cursor Shape", "Size Slash")
			<< i18n("Mouse Cursor Shape", "Size Backslash")
			<< i18n("Mouse Cursor Shape", "Size All")
			<< i18n("Mouse Cursor Shape", "Split Vertical")
			<< i18n("Mouse Cursor Shape", "Split Horizontal")
			<< i18n("Mouse Cursor Shape", "Pointing Hand")
			<< i18n("Mouse Cursor Shape", "Forbidden")
			<< i18n("Mouse Cursor Shape", "What's This?");
		m_cursorListData = new Property::ListData(keys, strings);
	}

	if(property)
		property->setListData(new Property::ListData(*m_cursorListData));
}

CursorEdit::~CursorEdit()
{
	delete m_cursorListData;
	m_cursorListData = 0;
}

TQVariant
CursorEdit::value() const
{
	return TQCursor(ComboBox::value().toInt());
}

void
CursorEdit::setValue(const TQVariant &value, bool emitChange)
{
	ComboBox::setValue(value.toCursor().shape(), emitChange);
}

void
CursorEdit::drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value)
{
	ComboBox::drawViewer(p, cg, r, value.toCursor().shape());
}

void
CursorEdit::setProperty(Property *prop)
{
	if(prop && prop != property())
		prop->setListData(new Property::ListData(*m_cursorListData));
	ComboBox::setProperty(prop);
}

#include "cursoredit.moc"
