/***************************************************************************
 *   Copyright (C) 2003 by S�astien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tdeparts/statusbarextension.h>
#include <kstatusbar.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <tqlabel.h>
#include <tqobjectlist.h>
#include "basketstatusbar.h"
#include "clickablelabel.h"
#include "global.h"
#include "bnpview.h"
#include "basket.h"
#include "tools.h"
#include <kiconloader.h>
#include <tqtooltip.h>

BasketStatusBar::BasketStatusBar(KStatusBar *bar)
	: m_bar(bar), m_extension(0), m_selectionStatus(0), m_lockStatus(0), m_basketStatus(0), m_savedStatus(0)
{
}

BasketStatusBar::BasketStatusBar(KParts::StatusBarExtension *extension)
	: m_bar(0), m_extension(extension), m_selectionStatus(0), m_lockStatus(0), m_basketStatus(0), m_savedStatus(0)
{
}

BasketStatusBar::~BasketStatusBar()
{
	//delete m_extension;
}

KStatusBar *BasketStatusBar::statusBar () const
{
	if(m_extension)
		return m_extension->statusBar();
	else
		return m_bar;
}

void BasketStatusBar::addWidget(TQWidget * widget, int stretch, bool permanent)
{
	if(m_extension)
		m_extension->addStatusBarItem(widget, stretch, permanent);
	else
		m_bar->addWidget(widget, stretch, permanent);
}

void BasketStatusBar::setupStatusBar()
{
	TQWidget* parent = statusBar();
	TQObjectList* lst = parent->queryList("KRSqueezedTextLabel");

	//Tools::printChildren(parent);
	if(lst->count() == 0)
	{
		m_basketStatus = new TQLabel(parent);
		m_basketStatus->setSizePolicy( TQSizePolicy(TQSizePolicy::Ignored, TQSizePolicy::Ignored, 0, 0, false) );
		addWidget( m_basketStatus, 1, false ); // Fit all extra space and is hiddable
	}
	else
		m_basketStatus = static_cast<TQLabel*>(TQT_TQWIDGET(lst->at(0)));
	delete lst;

	m_selectionStatus = new TQLabel(i18n("Loading..."), parent);
	addWidget( m_selectionStatus, 0, true );

	m_lockStatus = new ClickableLabel(0/*this*/);
	m_lockStatus->setMinimumSize(18, 18);
	m_lockStatus->setAlignment(TQt::AlignCenter);
//	addWidget( m_lockStatus, 0, true );
	connect( m_lockStatus, TQT_SIGNAL(clicked()), Global::bnpView, TQT_SLOT(lockBasket()) );

	m_savedStatusPixmap = SmallIcon("document-save");
	m_savedStatus = new TQLabel(parent);
	m_savedStatus->setPixmap(m_savedStatusPixmap);
	m_savedStatus->setFixedSize(m_savedStatus->sizeHint());
	m_savedStatus->clear();
	//m_savedStatus->setPixmap(m_savedStatusIconSet.pixmap(TQIconSet::Small, TQIconSet::Disabled));
	//m_savedStatus->setEnabled(false);
	addWidget( m_savedStatus, 0, true );
	TQToolTip::add(m_savedStatus, "<p>" + i18n("Shows if there are changes that have not yet been saved."));
}

void BasketStatusBar::postStatusbarMessage(const TQString& text)
{
	if(statusBar())
		statusBar()->message(text, 2000);
}

void BasketStatusBar::setStatusText(const TQString &txt)
{
	if(m_basketStatus && m_basketStatus->text() != txt)
		m_basketStatus->setText(txt);
}

void BasketStatusBar::setStatusBarHint(const TQString &hint)
{
	if (hint.isEmpty())
		updateStatusBarHint();
	else
		setStatusText(hint);
}

void BasketStatusBar::updateStatusBarHint()
{
	TQString message = "";

	if (Global::bnpView->currentBasket()->isDuringDrag())
		message = i18n("Ctrl+drop: copy, Shift+drop: move, Shift+Ctrl+drop: link.");
// Too much noise information:
//	else if (currentBasket()->inserterShown() && currentBasket()->inserterSplit() && !currentBasket()->inserterGroup())
//		message = i18n("Click to insert a note, right click for more options. Click on the right of the line to group instead of insert.");
//	else if (currentBasket()->inserterShown() && currentBasket()->inserterSplit() && currentBasket()->inserterGroup())
//		message = i18n("Click to group a note, right click for more options. Click on the left of the line to group instead of insert.");
	else if (Global::debugWindow)
		message = "DEBUG: " + Global::bnpView->currentBasket()->folderName();

	setStatusText(message);
}

void BasketStatusBar::setLockStatus(bool isLocked)
{
	if(!m_lockStatus)
		return;

	if (isLocked) {
		m_lockStatus->setPixmap(SmallIcon("encrypted.png"));
		TQToolTip::add(m_lockStatus, i18n(
				"<p>This basket is <b>locked</b>.<br>Click to unlock it.</p>").replace(" ", "&nbsp;") );
//		TQToolTip::add(m_lockStatus, i18n("This basket is locked.\nClick to unlock it."));
	} else {
		m_lockStatus->clear();
		TQToolTip::add(m_lockStatus, i18n(
				"<p>This basket is <b>unlocked</b>.<br>Click to lock it.</p>").replace(" ", "&nbsp;") );
//		TQToolTip::add(m_lockStatus, i18n("This basket is unlocked.\nClick to lock it."));
	}
}

void BasketStatusBar::setSelectionStatus(const TQString &s)
{
	if (m_selectionStatus)
		m_selectionStatus->setText(s);
}

void BasketStatusBar::setUnsavedStatus(bool isUnsaved)
{
	if (!m_savedStatus)
		return;

	if (isUnsaved) {
		if (m_savedStatus->pixmap() == 0)
			m_savedStatus->setPixmap(m_savedStatusPixmap);
	} else
		m_savedStatus->clear();
}

#include "basketstatusbar.moc"
